SNMPPORT(7)             XROUTER REFERENCE MANUAL             29/6/2025

NAME
        SNMPPORT -- UDP Port for Simple Network Management Protocol.

SYNOPSIS
        SNMPPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        SNMPPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the UDP "service port" number used
        for SNMP access to XRouter. If not present, or is set to
        0, SNMP facilities are disabled.

OPTIONS
        If a single argument is supplied, e.g. "SNMPPORT=161", it
        applies only to the host (Windows/Linux) TCP/IP stack.

        If TWO arguments are supplied, e.g. "SNMPPORT=161 1061",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting SNMPPORT to zero on a stack prevents SNMP
        access via that stack.

EXAMPLES
        SNMPPORT=0          -- Disable SNMP (default)
        SNMPPORT=161        -- Enable SNMP on host OS stack only
        SNMPPORT=161 1161   -- Port 161 on XR stack, 1161 on host
        SNMPPORT=161 0      -- Port 161 on XR stack only, no host

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability (see CAPFLAGS(6)).

        SNMP could be considered by some to be a security risk, so if
        enabling it on the XR stack, you might wish to limit access
        using ACL rules in IPROUTE.SYS.

SEE ALSO
        ACL(1)         -- IP Access Control List commands.
        CAPFLAGS(6)    -- Capability Flags.
        IPROUTE.SYS(8) -- IP Routing File.
        SNMP(9)        -- About Simple Network Management Protocol.
        XROUTER.CFG(8) -- Main Configuration File.

SNMPPORT(7)             END OF DOCUMENT

