;***********************|****** Max Width *****|*********************|
SOCKS(9)                XROUTER REFERENCE MANUAL             27/9/2023

NAME
        SOCKS -- SOCKS Proxy Server.

DESCRIPTION
        The purpose of the SOCKS proxy server in XRouter is long
        forgotten.

        It was included in XRouter either to allow users on amprnet
        to view Internet web pages, or to allow a LAN browser to
        gain a 44.x.x.x source address, to view amprnet web sites.


        What is SOCKS?
        ~~~~~~~~~~~~~~
        SOCKet Secure (SOCKS) V4 is a protocol that acts as a circuit
        level proxy for applications, routing traffic between a client
        and server through a proxy server.  It was intended for
        accessing external services through a firewall, as an
        alternative to using NAT (Network Address Translaton).

        SOCKS5 is defined in RFC 1928, and is an extension of the
        SOCKS4 protocol.  It offers more choices of authentication,
        adds support for IPv6 and UDP that can be used for DNS
        lookups.

        XRouter implements both SOCKS V4 and V5. The implementation is
        functional but incomplete.


        How it Works
        ~~~~~~~~~~~~
        A SOCKS proxy acts as both client and server simultaneously.
        A user client makes a TCP connection to the the socks server,
        and communicates with it using the SOCKS protocol. The user
        instructs the SOCKS proxy to connect to the target server,
        from which point onwards the proxy becomes the client of the
        target server.

                                  .---------.
            .--------. 62.31.1.3  |  XRPi   | 44.131.91.1 .--------.
            | server |-----<------|  SOCKS  |-------<-----| client |
            '--------'            |  proxy  |             '--------'
            83.1.24.5             '---------'            44.131.91.2

        The above diagram depicts an amprnet client (44.131.91.2)
        connected to an Internet server (83.1.24.5) via a SOCKS proxy.
        On the amprnet side XRouter is using the amprnet address
        44.131.91.1, and on the Internet side it is using the Internet
        address 62.31.1.3.

        As far as the target server is concerned, it is talking with
        62.31.1.3, whilst the user client is connected to 44.131.91.1.
        Anything sent by the client is relayed to the server by the
        proxy and vice versa.


        Client Requirements
        ~~~~~~~~~~~~~~~~~~~
        Client programs for use with this proxy must have SOCKS client
        capability.  Programs such as Internet Explorer, Firefox, and
        many other have this capability.


        Access Control
        ~~~~~~~~~~~~~~
        The "rules" to control which destinations are allowed to be
        accessed via the SOCKS proxy are contained in the SOCKS.ACL
        file. 

        The rules allow you to specify which destination IP
        addresses and TCP ports may be accessed by specified
        source IP ranges.

        If the file is not present, or contains no valid rules, all
        destinations are blocked. Attempting to access a blocked
        destination causes the proxy to return an "access denied"
        code.


        Configuration
        ~~~~~~~~~~~~~
        The server is available by default, and requires no setting
        up, other than the IP routing and egress control.

        The server's TCP port may be changed, or the server disabled,
        by using the SOCKSPORT=n directive in XROUTER.CFG.  Setting
        the port to zero disables the server.

FILES
        SOCKS.ACL, XROUTER.CFG

SEE ALSO
        ACCESS.SYS(8)  -- TCP/IP Access Control List.
        NAT(9)         -- Network Address Translation.
        SOCKS.ACL(8)   -- SOCKS Egress Control List
        SOCKSPORT(7)   -- TCP Port for SOCKS Proxy.
        XROUTER.CFG(8) -- Main Configuration File

SOCKS(9)              END OF DOCUMENT
