SOCKS.ACL(8)            XROUTER REFERENCE MANUAL            19/10/2023

NAME
        SOCKS.ACL -- SOCKS Proxy Egress Control File (Optional).

DESCRIPTION
        The SOCKS.ACL file contains "rules" to control which
        destinations are allowed to be accessed via the SOCKS
        proxy.

        The rules allow you to specify which destination IP
        addresses and TCP ports may be accessed by specified
        source IP ranges.

        If the file is not present, or contains no valid rules,
        all destinations are blocked. Attempting to access
        a blocked destination causes the proxy to return an
        "access denied" code.

FORMAT
        The format of the entries in SOCKS.ACL is the same as
        other .ACL (Access Control List) files.

        Each "rule" is specified on a separate line. Blank lines,
        or lines beginning with ';' or '#' are ignored. The
        maximum line length is 255 characters.

        Within each rule, fields must be separated by one or
        more spaces or tabs. The fields are as follows:

        <action> <src_ip>[/mask] <dst_ip>[/mask] <port(s)>

        The fields have the following meaning:

        <action>   PERMIT  Allow egress
                   DENY    Prevent egress

        <src_ip>   Source IP address (uplinked user).

        <dst_ip>   Destination IP address (target system).

        [mask]     Optional field.
                   Either: No. of bits (0-32) of address to
                           match from left to right,
                   Or:     Subnet mask in form n.n.n.n

        <port(s)>  One or more TCP service numbers (0-65535) on
                   the target system.  Allowed formats are "n",
                   "n,n,n", "n-n" or combination thereof.


        In the <src_ip> and <dst_ip> fields, 0.0.0.0/0 specifies
        "all addresses".

NOTE
        Rule testing stops at the *first* matching "permit" or
        "deny" statement, so it is vital that the list is ordered
        correctly.  For instance, to allow Internet users to
        access all LAN ports except 513 it would be ok to use:

                deny    0.0.0.0/0  192.168.0.0/24  513
                permit  0.0.0.0/0  192.168.0.0/24  1-65535

        but if the entries were reversed, the "permit" rule would
        match every case and the "deny" rule wouldn't be actioned.

EXAMPLES
        ; Allow LAN users to tunnel to anyone:
        PERMIT 192.168.0.0/24  0.0.0.0/0  0-65535
        ;
        ; Allow Internet users to tunnel only to certain
        ; ports on the node machine:
        PERMIT 0.0.0.0/0  192.168.0.245  23,87,1448,3600
        ;
        ; Allow Internet users to tunnel only to ports 23
        ; and 80 on the BBS machine:
        PERMIT 0.0.0.0/0  192.168.0.4  80,23
        ;
        ; Allow Amprnet users to access any Amprnet destination
        PERMIT 44.0.0.0/8  44.0.0.0/8  0-65535

FILES
       If required, SOCKS.ACL must be located in the same
       directory as the XRouter executable.

SEE ALSO       
       TELGUEST.ACL(8) -- Telnet Egress Control for Guest Users.
       TELPROXY.ACL(8) -- Telnet Proxy Egress Control File
       HTTP.ACL(8) -- HTTP Proxy Egress Control File

SOCKS.ACL(8)                END OF DOCUMENT
