;***********************|****** Max Width *****|*********************|
SOCKSPORT(7)            XROUTER REFERENCE MANUAL             27/9/2023

NAME
        SOCKSPORT -- TCP Port for SOCKS Proxy.

SYNOPSIS
        SOCKSPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        SOCKSPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the SOCKS Proxy. If not present, the default is 1080.

        SOCKS is a circuit level proxy for applications, as an
        alternative to Network Address Transslation (NAT).

OPTIONS
        If a single argument is supplied, e.g. "SOCKSPORT=1080", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "SOCKSPORT=1080 1090",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting SOCKSPORT to zero on a stack prevents TCP connections
        to the SOCKS proxy via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        SOCKS(9)       -- About the SOCKS Proxy.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

SOCKSPORT(7)           END OF DOCUMENT
