;***********************|****** Max Width *****|*********************|
SP(4)                   XROUTER REFERENCE MANUAL             29/3/2024

COMMAND
        SP -- Send Personal Message.

SYNOPSIS
        SP <to> [ @ <at> ]

DESCRIPTION
        The SP (Send Personal) command is used to send a personal
        message, i.e. one which is targeted at a single individual.

OPTIONS
        The <to> field must contain the recipient's callsign.

        The <at> field is semi-optional, and consists of the callsign
        of the recipient's "home BBS", plus other routing information
        where necessary. 

        This mailbox contains a database of known active mail users,
        called the "White Pages", or WP for short. If the recipient's
        callsign is known to WP there is no need to enter the <at>
        field, as the White Pages will automatically supply it.

        If you enter an incomplete address, the WP attempts to extend
        it into a full "Hierarchical Address (HA), but if you enter a
        full address, WP assumes you know best, and does not
        intervene. Therefore if you do supply a complete address,
        make sure it is EXACTLY right, or your mail may get lost.

        If you're sending a message to another user of this mailbox,
        you needn't enter the <at> field.

        If you're sending a message to a user of another mailbox, you
        only need to supply an address if the WP doesn't know the
        recipient.

        If in doubt, use the "I <callsign>" command to check if the
        recipient is in the WP database.

EXAMPLES
        SP G8PZT   <-- No address supplied. WP will supply it
                             if recipient is known to WP.

        SP G8PZT @ GB7PZT  <-- Partial address supplied. WP will
                                     attempt to extend it.
 
        SP G8PZT @ GB7PZT.#24.GBR.EU   <-- Full address supplied.
                                                WP won't intervene.

AVAILABILITY
        The SP command is available to all users.

SEE ALSO
        INFO(4)   -- Display Info About Mailbox / Users.
        SB(4)     -- Send Bulletin.
        SR(4)     -- Send Reply.
        WPAGES(9) -- White Pages Database

SP(4)                       END OF DOCUMENT
