STATS(9)                XROUTER REFERENCE MANUAL              3/1/2024

NAME
        STATS -- Explanation of Output of STATS Command.

SYNOPSIS
        This document attempts to explain some of the responses
        produced by the "stats" command.

SUMMARY PAGE
        Entering S[tats] without arguments produces a single page
        containing the following fields (values removed to make the
        display fit the page):

            Time active (mins):
            Overruns:
            Memory blocks: Min/Cur/Max
            Nodes: Cur/Max/free/poss
            Total bytes sent/rcvd:
            Ccts/MaxCcts L2/L3/L4/TCP:

            HTTP Rqst/Srvd/Bytes/Prxyd

            IP Heard/Reasm/Rcvd/Routed:
            IP Bad Hdr/Chksum/Version:
            IP Sent/Frag/Unsent/Total:

            L4 Connects Tried/Made/Rcvd:
            L4 total frames Sent/Rcvd:

            L4 Info Snt/Rcvd/Resent/Reseq:
            L4 Choke Snt/Rxd RSET Snt/Rxd:
            L4 Timeouts/Failures: 
            L3 Frames Hrd/Rcvd/Sent/Rlyd:

        "Time active" is the elapsed time in minutes since XRouter
                was last restarted. Also shown are day, hours,
                minutes and seconds.

        "Overruns" is nothing to worry about. It is a measure of how
                fast the main code is being executed. Expect low
                overruns on a fast machine and higher overruns when
                there is a lot of console scrolling.

        "Memory blocks" shows the minimum, maximum and current number
                of allocated memory blocks.

        "Known nodes" is the number of nodes in the table. "Cur" is
                the current figure, "Max" is the maximum, "Free" is
                the number of free table slots currently available,
                and "Poss" is the number of nodes the table might
                contain if it was not limited in size. If this last
                figure is higher than "max", it indicates that the
                table is not big enough, which may cause loss of low
                quality and "stale" entries in favour of better ones.

        "Total bytes sent/rcvd" are the total bytes sent and received
                by all the ports.  They include all ax25 overhead.

        "Ccts/MaxCcts" shows the current and highest number of
                simultaneous circuits that have been active at any
                time.  Separate figures are shown for Ax25 levels 2,
                3 and 4, and TCP/IP.

        "HTTP Rqst/Srvd/Bytes/Prxyd" shows the total number of HTTP
                requests received and served, the number of bytes
                served, and the number of requests that were proxied,
                i.e. handled on behalf of another system.

        "IP Heard/Reasm/Rcvd/Routed" shows the total number of IP
                frames heard (i.e. addressed to us and to others),
                reassembled from fragments, received (i.e. addressed
                to us), and routed to others.

        "IP Bad Hdr/Chksum/Version" shows the number of IP frames
                ignored due to corrupt IP headers (e.g. too short to
                be a legal IP frame), checksum mismatch, and
                incompatible IP version.  

        "IP Sent" is the no. of IP datagrams originated by XRouter,
                i.e. not routed from somewhere else.  "Frag" is the
                number of datagrams which had to be fragmented to fit
                a link.  "Unsent" is the number of datagrams which
                couldn't be sent due to low  memory or no route, and
                "Total" is the total number of datagrams or fragments
                thereof which were transmitted.

        "L4 Connects Tried/Made/Rcvd" shows the total number of
                outgoing and incoming AX25 level 4 connections.
                "Tried" is the number of requests initiated, "Made"
                is the number which were successful, and "Rcvd" is
                the number of incoming connects.

        "L4 total frames Sent/Rcvd" shows the total number of NetRom
                level 4 frames of all types sent and received by
                XRouter.

        "L4 Info Snt/Rcvd/Resent/Reseq:" shows the totals for NetRom
                level 4 information-bearing frames.  "Snt" is the
                number of frames originated by us.  "Rcvd" is the
                number of frames addressed to us. "Resent" shows how
                many were re-transmitted because no ack was received.
                "Reseq" is the number of frames that re-sequenced,
                i.e. were received out of sequence but subsequently
                used when the missing frames arrived.

        "L4 Choke Snt/Rxd RSET Snt/Rxd:" counts the number of NetRom
                level 4 choke and RESET frames sent and received by
                XRouter.  A sent choke indicates that we are
                receiving L4 data faster than we can process it, and
                instructs the other end to back off for a while.  A
                received choke indicates that we are sending data too
                fast for the other end of the link to handle.  Note
                that these figures do not necessarily indicate that
                there is something wrong with XRouter's links, as
                they apply to the "virtual circuit" from one process
                to another, which may span many intervening nodes.
                L4 resets are sent when frames are received for
                non-existent circuits.

        "L4 Timeouts/Failures" shows the number of times the NetRom
                level 4 T1 timer timed out while waiting for an ack,
                causing re-transmission of a frame.  "Failures" shows
                the number of level 4 circuits which were aborted due
                to excessive retries.

                    ------------------------------

        Entering "S[tats] *" produces the above followed a set of
        PORT stats, then a set of INTERFACE stats.  

                    ------------------------------

        Note that the L4, TCP and IP stats may be displayed in
        isolation using "S L4", "S TCP", and "S IP".

IP-ERRORS
        In addition to the normal IP stats shown above, "S[tats] IP"
        shows a set of IP error counters as follows:
    
            IP NoRoute NoGatewy RouteLoop:
            IP Ignored Rejected Discarded:
            IP Denied TTLExpired NoSocket:
            IP TooBig HostEncap XrEncap: 
            IP HdrParam Recursion:

        "NoRoute" means that a datagram was dropped because there was
                no suitable route in the IP routing table, or the
                route pointed to a non-existent PORT.

        "NoGatewy" means that there is no suitable gateway for an
                encapsulated datagram. 

        "RouteLoop" means that the route for an encapsulated datagram 
                is back to the gateway it came from.

        "Ignored" means received datagrams ignored because they were
                on the same subnet as XRouter, but not addressed to
                it. Not an error, just info.

        "Rejected" means frames rejected because they matched an IP
                route entry of type "r" (reject). Unless IP QUIET is
                set, these elicit an ICMP resonse of HOST UNREACHABLE.

        "Discarded" means datagrams dropped because they matched an
                IP route entry of type "s" (silent discard). No ICMP
                response is sent.

        "Denied" means datagrams carrying TCP that were droppped
                because they failed XRouter's access control rules.

        "TTLExpired" means datagrams that couldn't be routed because
                their Time To Live counter had expired.

        "NoSocket" counts datagrams dropped because they were the
                wrong protocol for a route mode of "k" (kernel).

        "TooBig" means datagrams rejected because they were too large
                for the outgoing MTU and had the DF (don't fragment)
                option set. Unless IP QUIET is set, these elicit an
                ICMP response of "fragmentation needed".

        "HostEncap" counts encapsulated datagrams (IPIP, IPENCAP,
                IPUDP) that were suupposed to be routed via the
                operating system's IP stack, but failed to do so.

        "XrEncap" counts encapsulated datagrams (IPIP, IPENCAP,
                IPUDP) that were suupposed to be routed via XRouter's
                own IP stack, but failed to do so.

        "HdrParam" means datagrams dropped due to a problem in their
                IP header parameter lists.

        "Recursion" counts datagrams that were dropped because they
                traversed the IP stack too many times.

AXIP STATS
        These are displayed using "S[tats] AXIP".

                total frames heard
                frames ignored (too short)
                frames ignored (bad CRC)
                frames ignored (unsolicited)
                valid frames received 
                frames sent
                frames unsent (resolution failure)
                frames unsent (no route)
                frames unsent (routing loop)
                frames unsent (miscellaneous reasons)

        "Total frames heard" includes valid AXIP plus all other frames
                heard on the interface.

        "Too short" are received frames too short to be legal AXIP.

        "Bad CRC" are received frames long enough to be legitimate
                AXIP, but failed the CRC test.

        "Unsolicited" are valid AXIP from unrecognised senders.

        "Valid frames received" are the ones accepted into AX25.

        "Resolution Failure" occurs when IPLINK has been specified as
                a hostname, but that hostname can't be resolved to an
                IP address.

        "No Route" occurs when there is no IP route which can handle
                the encapsulated packet.

        "Routing loop" occurs when the IP routing is set up
                incorrectly, causing the encapsulated packet to be
                encapsulated again ad infinitum.

        "Miscellaneous Reasons" usually indicates a temporary IP
                routing problem, such as a loose plug.

AXUDP STATS
        These are displayed using "S[tats] AXUDP".

                total frames heard
                BPQ keepalives ignored
                other non-AXUDP ignored 
                unsolicited AXUDP ignored
                valid AXUDP received 
                frames sent
                frames unsent (resolution failure)
                frames unsent (no route)
                frames unsent (routing loop)
                frames unsent (miscellaneous reasons)

        "Total frames heard" includes valid AXUDP plus all other
                frames heard on the interface.

        "BPQ keepalives" are packets from BPQ systems that are
                intended to keep the AXUDP connection alive.

        "Other non-AXUDP" is anything else (other than BPQ
                keepalives, which is not valid AXUDP, e.g. port
                scans, malicious activity etc.
 
        "Unsolicited AXUDP" is valid AXUDP from sources with whom we
                don't have a formal arrangement.

        "Valid AXUDP received" are the ones accepted into AX25.

        "Resolution Failure" occurs when IPLINK has been specified as
                a hostname, but that hostname can't be resolved to an
                IP address.

        "No Route" occurs when there is no IP route which can handle
                the encapsulated packet.

        "Routing loop" occurs when the IP routing is set up
                incorrectly, causing the encapsulated packet to be
                encapsulated again ad infinitum.

        "Miscellaneous Reasons" usually indicates a temporary IP
                routing problem, such as a loose plug.

AXTCP STATS
        These are displayed using "S[tats] AXTCP".

                total frames heard
                frames ignored (too short)
                frames ignored (bad header) 
                frames ignored (bad CRC)
                frames received OK
                frames sent
                frames unsent (not connected)
                frames unsent (miscellaneous reasons)
                failed / blocked logins

        "Total frames heard" includes valid AXTCP plus all other
                frames heard on the interface.

        "Too short" are received frames too short to be legal AX25.

        "Bad header" counts frames where the length specified by the
                header didn't match the actual frame length. These
                could be malicious, so the connection is dropped for
                safety.

        "Bad CRC" are received frames long enough to be legitimate
                AXTCP, but failed the CRC test.

        "Frames received OK" are the ones accepted into AX25.

        "Frames sent" are the ones successfully sent.

        "Not connected" indicate frames that couldn't be sent because
                the TCP link was not connected.

        "Miscellaneous reasons" indicates frames that couldn't be sent
                due to a temproary problem such as insufficient memory
                or a blocked TCP queue.

        "Failed / blocked logins" are failed attempts to connect to
                the AXTCP server. Usually this results from port
                scanning or other malicious activity.

PORT STATS
        Displayed by "S[tats] L2" "S[tats] L3" and "S[tats] *".

        Note that on a system with more than 7 ports the display may
        wrap. This is not ideal, and may be addressed in future
        versions.

        The PORT stats start with Layer 3 counters, which may also be
        displayed in isolation using the "S[tats] L3" command:

                        Port:     2      4      6      8      9
            L3 Frames Heard       0    309      0      0      7 
            L3 Frames Rcvd        0    137      0      0      7
            L3 Frames Sent        0     59      0      0      0
            L3 Frames Relayed     0      0      0      0      0
                 
        "L3 Frames Heard" is the total number of ax25 level 3 frames
               heard, no matter who they are addressed to.

        "L3 Frames Rcvd" is the number of ax25 level 3 frames which
               were addressed to our XRouter.

        "L3 Frames Sent" is the number of ax25 level 3 frames which
               originated at our XRouter.

        "L3 Frames Relayed" is the number of ax25 level 3 frames
               which were routed through our system from elsewhere.


        After the level 3 stats come the ax25 level 2 counters, one
        per port. These can also be displayed in isolation using the
        "S[tats] L2" command:

                        Port:     2      4      6      8      9
            L2 Frames heard       0    628      0      0     78
            L2 Frames rcvd        0    520      0      0     74
            L2 Resequenced        0      0      0      0      0
            L2 Reassembled        0      0      0      0      0 
            L2 Info Received      0      0      0      0      0
            L2 T1 Timeouts        0    239      0      0      0
            L2 Digipeated         0      0      0      0      0
            L2 Info Sent          0    208      0      0      3 
            L2 Info re-sent       0      0      0      0      0
            L2 Fragmented         0      0      0      0      0
            L2 Frames Sent       12    491     18     13     87
            L2 REJ Received       0      0      0      0      0
            L2 Rx out of seq      0      0      0      0      0
            L2 Frames Corrupt     0      1      0      0      0
            L2 FRMRs Sent         0      0      0      0      0
            L2 FRMRs Rcvd         0      0      0      0      0
            Bytes Rcvd        37032  71809      0      0   1589
            Bytes Sent            0  21607    869   1460   1597
            Poll Timeouts         0      0      0      0      0
            Tx/Rx Active%        0/0    0/0    0/0    1/0    0/0
            Tx/Rx Peak%          0/0    0/0    0/0    1/0    0/0 
            Tx/Rx Mean%          0/0    0/0    0/0    0/0    0/0
.

        "L2 Frames heard" is the total number of ax25 level 2 frames
                heard, whether addressed to us or not.

        "L2 Frames rcvd" is the number of ax25 level 2 frames
                received which were addressed to XRouter.

        "L2 Resequenced" is the number of ax25 level 2 frames
                received out of sequence and subsequently used when
                the missing frames arrived.

        "L2 Reassembled" is the number of ax25 level 2 frames
                successfully reassembled from fragments.

        "L2 Info Received" is the number of ax25 level 2 information
                bearing frames received, i.e. addressed to XRouter.

        "L2 T1 Timeouts" counts the number of times that the ax25
                level 2 T1 (frack) timer timed out, causing
                transmission of a poll frame.

        "L2 Digipeated" is the number of ax25 level 2 frames
                digipeated by the port.  Note that if digiport isn't
                zero they may actually have been retransmitted by
                another port, but are recorded on the "receiving"
                port only.

        "L2 Info Sent" is the total number of ax25 level 2
                information frames sent by XRouter.

        "L2 Info re-sent" records how many ax25 level 2 information
                frames were re-sent due to frame loss.  A high figure
                here, in proportion to the "info sent" figure,
                indicates a problem with the RF link, the L2
                settings, or the other end's system (e.g. desense, or
                running out of buffers).

        "L2 Fragmented" is the number of ax25 level 2 information
                frames fragmented to fit the outgoing link.

        "L2 Frames Sent" is the total number of ax25 level 2 frames,
                of any type, sent by XRouter, i.e. it includes all
                info, supervisory, and digipeated frames.

        "L2 REJ Received" is the number of ax25 level 2 "reject"
                frames received, which indicate that the other end of
                the link didn't receive some of our frames.  There
                are many possible reasons for this, some of which are
                mentioned in the next paragraph.

        "L2 Rx out of seq" shows how many ax25 level 2 frames were
                received out of sequence, and indicates that some
                incoming frames are getting lost or corupted.  A few
                of the possible causes might be: signal too weak,
                fading, other signals on channel, natural or man made
                interference, desense or key clicks from adjacent
                transmitters, poor RX audio response, low received
                audio, over-deviation, RF frequency mismatch, badly
                aligned RX, TNC hardware problems, synthesised rig
                taking too long to stabilise on RX after TX, other
                end's synthesised rig taking too long to stabilise on
                TX, hum, noise, distortion or disturbances on
                modulated audio... the list is endless.

        "L2 Frames Corrupt" is the number of frames which were dumped
                because they were too short to be legal ax25 level 2
                frames, or were in some way invalid.  It is sometimes
                possible for a KISS TNC, especially if running "open
                squelch", to send garbage to the router,  or the frame
                may be trashed by bit errors on the serial link
                between TNC and XRouter, and in either case these
                frames are dumped if the error can be detected.

        "L2 FRMRs Sent/rcvd" shows how many ax25 level 2 "Frame
                Reject" frames were sent by the router, or received
                by it, indicating serious protocol errors or
                deliberate interference.

        "Bytes Sent" and "Bytes Rcvd" simply provide a port by port
                breakdown of the total bytes sent/rcvd figure.

        "Poll Timeouts" counts the number of times a pollled KISS TNC
                was polled with no response being received from it.
                A large figure might indicate a crashed, disconnected
                or unpowered TNC, or data loss on the serial link.

        "Tx/Rx Active%" are running averages of the percentage of
                time that the TX is tranmitting and RX is receiving.
                High figures would indicate a saturated RF channel.

        "Tx/Rx Peak%" are the peak values attained by the above.

        "Tx/Rx Mean%" are the long term averages of the TX and RX
                activity, i.e. since XRouter was booted.

INTERFACE STATS
        Following the PORT stats are the INTERFACE stats, which can
        also be displayed in isolation using S[tats] L1":

                   Interface:     2      4      9
            RX Bytes:         2048K  71809   1589
            RX Overruns:          0      0      0
            RX CRC/Parity:        0      0      0
            RX Framing err:       0      0      0
            RX Break/Abort:       0      0      0 
            RX Overflow:          0      0      0
            RX Misc. errors:      0      0      0
            RX Read errors:       0      0      0
            TX Bytes:          3463      0   2466
            TX Overflows:         0      0      0
            TX Underruns:         0      0      0
            TX Write errors:      0      0      0  

        "RX Overruns" counts the number of times a byte was received
                before the previous one was read by the CPU.  A high
                number indicates that the PC is too slow for the
                serial port or HDLC card data rate.  A 16550-based
                serial card may help if the port doesn't already use
                one.  Failing that, you will have to reduce the baud
                rate.

        "TX Underruns" is used only by HDLC cards, and counts the
                number of times the TX went empty while waiting for
                another frame byte to be loaded.  A significant
                figure indicates the computer is too slow for the
                baud rate.  Each underrun causes an aborted frame.

        "CRC/Framing Errors" counts either the number of bytes
                received without proper stop bits (ASYNC interfaces),
                or the number of received frames which are corrupt
                (HDLC cards).  For ASYNC interfaces, a significant
                count here can indicate a hardware problem, such as a
                faulty line driver, serious RS232 line noise or
                distortion, or significant baud rate mismatch.  For
                HDLC cards it indicates a level 1 problem, such as
                distortion in the TX/RX RF or audio paths, or simply
                a lot of packet collisions.

        "Break/Abort Errors" counts the number of times a line
                "space" condition longer than 1 word interval was
                received.  For serial ports this can indicate a
                faulty line driver, a faulty diode matrix on a
                multi-drop kiss system, or even (as happened to me)
                a malfunctioning TNC EPROM.  On HDLC cards it can
                result from insufficient audio drive from the RX, a
                mismatched baud rate, squelch tails, or genuine ABORT
                sequences transmitted by the other end of the link.

        "CRC Errors" shows the number of frames abandoned due to CRC
                (Cyclic Redundancy Check) or checksum error.  For
                KISS interfaces this is only maintained if the
                CHECKSUM kissoption is enabled.

        "Rx Overflow err" shows the number of times a frame was
                abandoned because it was too large to fit into the
                receive buffer.

        "Tx Overflow err" counts the number of times that the TX
                couldn't accept a character (serial devices) or a
                frame (block devices) because the TX buffer was full.
                If you persistently get a high value, it indicates
                that the device is too slow for the data throughput.

        "RX Misc. errors" counts all sorts of miscellaneous errors,
                and the meaning is different for each type of
                interface.  For example, on KISS interfaces it counts
                KISS framing errors. 

IDS STATS
        Finally "S[tats] IDS", which is sysop-only, elicits a summary
        of XRouter's IDS (Intrusion Detection System) stats, which
        may look something like this: 

            IDS Events:       25778   Cmd Overflow:     0
            FTP DIR Hacks:    0       IP Addr Heard:    100
            IP Addr Banned:   200     IP Banned Total:  183     
            IP Dgram Blocked: 2076    ICMP Frm Blocked: 32
            Honeypot Hits:    0       UDP Segs Ignored: 3251968
            UDP Segs Blocked: 22      TCP Segs Ignored: 9967
            TCP Segs Blocked: 2022    TCP Conn Blocked: 763     
            Bogus SYNs:       15776   Smurf Attacks:    0
            Fraggle Attacks:  0       IP Frag Attacks:  0
                      (Tiny=0  Huge=0  Overlapped=0)
            TCP Scans: SYN=1 FIN=0 ACK=57 NUL=0 MAI=82 XMS=0 OTH=9600
            Rejected Logins:  763 (Telnet=763, Rlogin=0, FTP=0,
               TelProxy=0)
            Malicious Logins: 182 (Telnet=182, Rlogin=0, FTP=0,
               TelProxy=0)
            HTTP No-Request:  0       HTTP Bad Request: 0
            HTTP Blocked:     0

        "IDS Events" is the total number of times the IDS has noticed
                something suspicious.

        "Cmd Overflow" is the number of times that someone has
                attempted a buffer overflow attack.

        "FTP DIR Hacks" is the number of attempts to escape from the
                FTP root directory.

        "IP Addr Heard" is the number of unique IP addresses heard.

        "IP Addr Banned" is the number of IP addresses in the "banned
                IP" table. As the table is saved across reboots, it
                is normal for it to be full.

        "IP Banned Total" is the number of new IP addresses banned
                since bootup. This figure may exceed the table size
                because new bans replace stale ones.

        "IP Dgram Blocked" is the number of IP datagrams blocked
                because the sender's IP address was in the banned IP
                table.

        "ICMP Frm Blocked" is the number of ICMP frames blocked
                because the sender's IP address was in the banned IP
                table.

        "Honeypot Hits" is the number of times someone attempted to
                access one of the "honeypot" ports. These are traps
                which lure port scanners into an IP ban.

        "UDP Segs Ignored" is the number of UDP segments ignored
                because there was no matching socket to receive them.

        "UDP Segs Blocked" is the number of UDP segments blocked
                because the sender's IP address was on the banned IP
                list.

        "TCP Segs Ignored" is the number of TP segments ignored
                because there was no matching listener socket.

        "TCP Conn Blocked" is the number of TCP connection attempts
                blocked because the sender was on the banned IP list.

        "Bogus SYNs" is the number of TCP connection attempts blocked
                because the SYN was malformed or maliciously crafted.

        "Smurf Attacks" are distributed denial of service attacks
                which use ICMP directed at broadcast addresses.

        "Fraggle Attacks" are variations of Smurf attacks, where the
                attacker sends lots of traffic to UDP ports 7 (Echo)
                and 19 (CHARGEN)

        "IP Frag Attacks" is the number of IP fragmentation attacks.
                These attacks attempt to overwhelm or crash the IP
                fragment reassembly mechanism.
                Tiny - First fragment is too short to contain valid
                       TCP+IP headers, so it could bypass port-number
                       filtering.
                Huge - Fragment exceeds maximum datagram size.
                Overlapped - Fragments which overlap but don't align.

        "TCP Scans" is the number of TCP port scans detected and
                blocked. Totals for each scan type are shown
                separately:
                SYN - Scanner sends SYN but never completes the 3 way
                      TCP handshake.
                FIN - TCP segments with only the FIN bit
                ACK - Only the ACK flag is set
                NUL - NULL scan (no flags are set)
                MAI - Maimon scan (FIN and ACK flags set)
                XMS - Xmas Tree scan (FIN, PSH and URG flags set)
                OTH - Other types of scan
 
        "Rejected Logins" are Telnet / FTP etc logins which were
                rejected because the login credentials were incorect.

        "Malicious Logins" are TCP logins attempted using suspicious
                credentials.

        "HTTP No-Request" is the number of connections to XRouter's
                HTTP server which didn't contain an HTTP request.
                These are usually the result of port scanning.

        "HTTP Bad Request" is the number of malformed or maliciously
                crafted HTTP requests. These are usually attempts to
                exploit vulnerabilities in certain types of HTTP
                server or operating system.

        "HTTP Blocked" is the number of HTTP server connections
                refused because the sender's IP was in the blocked
                IP list.


SEE ALSO
        STATS(1) -- Display XRouter Statistics.

STATS(9)                    END OF DOCUMENT
