STATS(1)                XROUTER REFERENCE MANUAL             18/8/2025

COMMAND
        STATS -- Display XRouter statistics.

SYNOPSIS
        S[tats] [ L1 | L2 | L3 | L4 | IP | UDP | TCP | * | ? | AX25
                | AXIP | AXUDP | AXTCP | LAPB | ICMP | IDS | NCMP
                | NODES ]

AVAILABILITY
        All users, but IDS stats can only be viewed by sysop.

DESCRIPTION
        Displays information about the performance of XRouter, such 
        as the uptime, the no. of packets routed, error rates etc.

        Stats may be displayed for a single ISO layer, or for all
        layers.  

OPTIONS
        Entering S by itself will give a single page synopsis.

        "S ?" displays a list of the subcommands,
 
        "S *" displays the summary stats for all layers.

        "S <layer>" displays more detailed stats for <layer> as
                    follows:

             L1    - Physical layer (interfaces etc)
             L2    - Link layer (AX25L2, Ethernet etc)
             AX25  - AX25 unconnected mode
             LAPB  - AX25 connected mode
             NODES - NetRom routing table.
             L3    - Network layer (NetRom datagrams)
             NCMP  - NetRom Control Message Protocol
             L4    - Transport layer (NetRom connections)
             IP    - Internet Protocol layer (non-ISO)
             ICMP  - Internet Control Message Protocol
             UDP   - User Datagram Protocol
             TCP   - Transmission Control Protocol layer (non-ISO)
             AXIP  - AX25 encapsulated in IP
             AXUDP - AX25 encapsulated in UDP/IP
             AXTCP - AX25 encapsulated in TCP/IP

        "S IDS" displays brief stats for XRouter's Intrusion
        Detection System.  This is mainly of use to remote sysops,
        because all the information is already available to console
        sysops via the "Security Monitor" window.

        A typical response  to "S IDS" is as follows: 

        G8PZT:KIDDER} Security stats:

        TCP Scans: SYN=837 FIN=0 ACK=152 NUL=0 MAI=37 XMS=0 OTH=1632
        Bogus SYNs: 2083
        Rejected Logins: Telnet=77, Rlogin=0, FTP=7, TelProxy=0
        Malicious Logins: Telnet=334, Rlogin=0, FTP=47, TelProxy=0
        FTP directory hacks: 0
        IDS Notifications: 132682
        IP frames from banned senders: 3155
        IP Fragmentation attacks: Tiny=5  Huge=0  Overlapped=3
        Smurfs: 0  Fraggles: 0
        Honeypot Hits: 27

        Note that if your node is AX25-only, or completely hidden
        behind a firewall, many of these stats will be 0, which is a
        good thing :-)

EXAMPLES
             S       Display single page synopsis
             S *     Display all stats for all layers
             S IP    Display only the IP-layer stats

LIMITATIONS
        Screen width is only 80 characters, so on systems with many
        ports and interfaces the display may wrap.

SEE ALSO
        STATS(9) -- Explanation of the individual stats fields.

STATS(1)                         END OF DOCUMENT
