SYNCACHE(9)            XROUTER REFERENCE MANUAL               6/9/2023

NAME
        SYNCACHE -- TCP SYN Cache.

DESCRIPTION
        To combat the ever-growing problem of TCP port scanning,
        which wastes TCP resources, XRouter includes a "SYN cache".

        In "normal" RFC793 TCP, a received SYN elicits a SYN|ACK,
        and the TCP state machine allocates resources then moves to
        the  SYN_RECEIVED state, awaiting an ACK from the caller.

        The nastier port scans tend to send a SYN, wait for the ACK,
        then move on without sending a reset. This leaves dozens of
        half-open connections, which eventually prevent new
        connections from being formed.

        With a SYN cache, a received SYN elicits a SYN|ACK as before,
        but no resources are allocated. The SYN is cached for a short
        while. If an ACK is received for our reply, a normal
        connection is created, otherwise the SYN is discarded. This
        makes the TCP stack far more resistant to port scans.

        The TCP CACHE command is used to display and adjust settings.

SEE ALSO
       TCP(1) -- TCP Status / Configuration Commands

SYNCACHE(9)                END OF DOCUMENT
