;***********************|****** Max Width *****|*********************|
TALK(1)                 XROUTER REFERENCE MANUAL             28/9/2023

COMMAND
        TALK -- Talk to a user or another sysop.

SYNOPSIS
        TA[lk] <sessnum | nodecall>

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The TALK command allows a sysop to have a keyboard chat with
        a locally connected user, or the sysop of another XRouter.

        It is usually, but not always, invoked in response to a user
        issuing the YELL command.

        If the argument is a session number, e.g. "talk 123", it
        allows the sysop to talk to a logged-in user.

        If the argument is a node callsign or alias, for example.
        "talk VK2DOT"  it initiates a private keyboard to keyboard
        chat with the sysop of that node, if he is available. This
        is not related to the "sysop chat" channel on the chat
        server. It is the NetRom equivalent of the TTYLINK command,
        and this form is identical to the NTTY command.

        The sysop of the target node has 90 seconds to respond. At
        any point during or after the 90 seconds, the caller has the
        option to leave a short one-line message (160 chars max) or
        to abort the call. Messages are saved into the sysop's PMS.

        If the sysop takes more than 90 seconds to respond, and the
        user has not disconnected, the sysop can still use the
        "talk <sessnum>" form of the command to initiate a chat with
        the user.

EXAMPLES
        TALK 21     - Initiate chat with session 21 on this node
        TALK KIDDER - initiate chat with sysop of KIDDER node

LIMITATIONS
        Sysops may interrupt users' command sessions, but may not
        interrupt established circuits, because that might damage
        the data being sent or received by the user.

        The "TALK <nodecall>" form currently only works if the target
        node is running a recent version of XRouter. Other types of
        node will not (yet) respond to the request. 

SEE ALSO
        NTTY(1)    -- Netrom TTYLink.
        YELL(1)    -- Page the sysop.
        TTYLINK(1) -- Keyboard chat with another TCP/IP system.

TALK(1)                  END OF DOCUMENT
