;***********************|****** Max Width *****|*********************|
TCP-IFACE(6)            XROUTER REFERENCE MANUAL             28/9/2023

NAME
        TCP-IFACE -- Interface type "TCP".

DESCRIPTION
        Interface type "TCP" allows systems on the same machine, or
        on different machines, to be linked together using various
        protocols tunneled inside a TCP stream.

        This works equally well for both "datagram" and "stream"
        protocols. It can be used to connect to applications such
        a Direwolf, or to tunnel protocols through firewalls.

        A TCP interface can be either a SERVER or a CLIENT. Unlike
        the AXTCP interface it cannot be both at the same time. The
        server passively listens for connections, and the client
        actively makes connections.

        A typical TCP client interface would be defined thus:

            INTERFACE=16
                TYPE=TCP
                ID=KISSTCP (Direwolf)
                PROTOCOL=KISS
                IOADDR=127.0.0.1       ; Direwolf IP address
                INTNUM=8001            ; Direwolf TCP port
                MTU=1500
            ENDINTERFACE

        Note Some keywords are re-purposed to avoid creating new ones!

        TYPE, PROTOCOL, IOADDR, INTNUM, COM and MTU are mandatory.

        ID is an optional text which identifies the interface on
           various displays. Keep it concise. 20 chars max.

        IOADDR is used differently in client and server cases:
               In the CLIENT case, it specifies the IP address of the
               target server or app. Use 127.0.0.1 if the target is
               on the same machine as XRouter.
               In the SERVER case it must be set to 0.

        INTNUM is also used differently in client and server:
               In the CLIENT case, it specifies the TCP port of the
               target server or application.
               In the SERVER case, it specifies the TCP port the
               server is listening on.

        MTU specifies the "Maximum Transmission Unit", i.e. the
            maximum payload size for a packet transmitted on the
            interface. The value depends on the protocol.

        PROTOCOL is the protocol to use on the interface:

            ASCII    - Plain text
            AX25     - Plain AX25, no CRC
            ETHER    - Ethernet
            HDLC     - AX25 with CRC, but no HDLC flags
            IP       - Plain IP
            KISS     - Basically AX25 within SLIP
            NETROM   - Netrom backend serial link.
            PPP      - Point to Point Protocol
            SLIP     - Serial Line Internet Protocol
            TNC      - TNC Control
            TNC2     - TNC2 Emulation.

            (see PROTOCOL(7) for more detail)

        A typical TCP server interface, running KISS over TCP would
        be defined thus:

            INTERFACE=16
                TYPE=TCP
                ID=KISSTCP Server
                PROTOCOL=KISS
                IOADDR=0.0.0.0         ; 0 signifies a server
                INTNUM=3276            ; Listening TCP port
                MTU=1500
            ENDINTERFACE

NOTES
        To avoid accidental recursion, this interface uses the Linux
        IP stack. Thus if the interface is a SERVER, and INTNUM is
        below 1024, XRouter will need CAP_NET_BIND_SERVICE capability,
        or will need to run from a "root" account.

SEE ALSO
        IFACES(6)      -- Interfaces.
        CAPFLAGS(6)    -- Capability Flags.
        KISS(9)        -- KISS Protocol.
        PORTS(6)       -- Ports in XRouter.
        PPP(9)         -- Point to Point Protocol.
        PROTOCOL(7)    -- Protocol Used on INTERFACE.
        TNC2(9)        -- TNC2 Emulation.
        XROUTER.CFG(8) -- Main Configuration File.

TCP-IFACE(6)               END OF DOCUMENT
