TCP-PORTS(6)           XROUTER REFERENCE MANUAL              22/9/2023

NAME
        TCP-PORTS -- TCP Service Ports.

DESCRIPTION
        TCP "service ports" (not to be confused with radio ports),
        are standard or "well known" numbers between 0 and 65535
        which are used in combination with an IP address to access a
        particular process (usually a server) on a system.

        The default TCP service port numbers for XRouter's servers,
        and the corresponding configuration keywords used in
        XROUTER.CFG are as follows:

            Keyword     TCP Port    Service Name
            --------------------------------------------
            ECHOPORT           7    Echo server
            DISCARDPORT        9    Discard server
            FTPPORT           21    FTP server
            TELNETPORT        23    Telnet server
            FINGERPORT        79    Finger server
            HTTPPORT          80    HTTP server
            TTYLINKPORT       87    Raw TTY link
            RLOGINPORT       513    Remote login
            SOCKSPORT       1080    Socks proxy server
            APRSPORT        1448    APRS server
            MQTTPORT        1883    MQTT server (broker)
            TELPROXYPORT    2323    Telnet proxy server
            CHATPORT        3600    Chat server
            AGWPORT         8000    AGW TCP host API
            RHPPORT         9000    XRouter host API

        By default, all the above services are enabled, on all of
        XRouter's IP addresses. I.e. the global IPADDRESS and any
        port overrides, allowing them to be used by TCP/IP over
        AX25, TCP/IP over SLIP/PPP etc..

        If you are *not* using the EXTERNAL interface to share the
        Ethernet or WiFi adaptors, the default case is that these
        services will also be available via the Linux kernal IP
        addresses.

        If you *are* using the EXTERNAL interface to share the
        Ethernet or WiFi adaptors, these services will NOT be
        available via the Linux kernal IP addresses unless you
        explicitly say so (see below).

        See LAN(9) for more information on using the EXTERNAL
        interface. 


        Overriding Default TCP Service Ports
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        You may wish to disable services, or change their TCP port.

        For instance, you may need to move the Telnet port if you
        have another process using TCP port 23 on the same machine.
        Or you may wish to disable the SOCKS server because you don't
        need it.

        You may also choose to make some services available on
        XRouter's TCP/IP stack and not on Linux stack, or vice versa.

        To override the default, use one or more of the above
        configuration keywords in the GLOBAL section of XROUTER.CFG.

        If you use the keyword without an argument, or with an
        argument of zero, that service is disabled, for example, the
        following formats disable the Telnet server on both XRouter
        and Linux IP stacks:

                TELNETPORT=
                TELNETPORT=0

        If you use the keyword with a single argument, the result
        depends on whether you are using the EXTERNAL interface or
        not.

        If you *are* using the EXTERNAL interface, the argument
        applies only to the XRouter stack.

        If you are *not* using the EXTERNAL interface, the argument
        applies to BOTH stacks.

        With those rules in mind, the following example moves the
        Telnet server from the default port (23), to port 88:

                TELNETPORT=88

        If you supply TWO arguments, the first *always* applies to
        XRouter's stack and the second *always* applies to the Linux
        stack. 

        You may supply different numbers for each stack, or disable
        one and not the other.  The numbers must be separated by
        whitespace, NOT commas.

        For example, the following specifies that the TELNET server
        shall use TCP port 88 on XRouter's TCP/IP stack, and port 89
        on the Linux stack:

                TELNETPORT=88 89

        This one disables the Telnet server on XRouter's TCP/IP
        stack, whilst enabling it for port 88 on the Linux stack:

                TELNETPORT=0 88

        Finally, this example enables the Telnet server on port 88 of
        XRouter's TCP/IP stack, whilst disabling it on Linux stack: 

                TELNETPORT=88 0

CAVEATS
        Unless you run XRouter with root privileges, or grant it the
        CAP_NET_BIND_SERVICE capability, you will NOT be able to open
        any port number less than 1024 on the Linux stack.

        In such a case, a directive like this:

             RLOGINPORT=0 513

        will return an error like this:

             Error 13 opening RLogin server port 513

        Moving the port above 1023, e.g. 7513 would solve the
        problem, so long as you can remember the port number!

        If you want to use ports below 1024, and you don't want to
        run XRouter with root privileges, you can use setcap to set
        the CAP_NET_BIND_SERVICE capability as follows (assuming the
        xrouter executable is "xrpi"):

            sudo setcap cap_net_bind_service=pe xrpi

        This will overwrite any previous capability set on that file,
        so if you are using the EXTERNAL interface, you need to set
        the CAP_NET_RAW capability at the same time, as follows:

            sudo setcap cap_net_raw,cap_net_bind_service=pe xrpi

        Another option is to use rinetd to redirect connections to a
        higher port number. For instance the following line in
        rinetd's configuration:

            192.168.0.10    513      127.0.0.1   8000

        would forward connections for port 513 on address
        192.168.0.10 to localhost port 8000 which XRouter can listen
        on even without root privileges.

        Finally, you could simply disable the port on the Linux
        stack, for example:

            TELNETPORT=23 0

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        IP-STACKS(6)   -- TCP/IP Stacks in XRouter.
        LAN(6)         -- LAN Interfacing.
        RUNROOT(6)     -- Run as Root or Not?
        SERVERS(9)     -- Servers in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

TCP-PORTS(6)          END OF DOCUMENT
