TCP(1)                 XROUTER REFERENCE MANUAL             18/8/2025

COMMAND
        TCP -- TCP status / configuration commands.

SYNOPSIS
        TC[p] C[ache] L[ife] [secs]
        TC[p] C[ache] SI[ze] [slots]
        TC[p] C[ache] S[tatus]
        TC[p] L[isteners]
        TC[p] R[eset] <sock#> [sock#]...
        TC[p] S[tatus] [sock#]
        TC[p] STATS

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The TCP command is used to display or modify various
        settings in XRouter's TCP module, and to reset connections.

OPTIONS
        "TC[p] C[ache] L[ife] [secs]" is used to display or change
        the SYN cache lifetime. The default is 10 seconds.

        "TC[p] C[ache] SI[ze] [slots]" is used to display or change
        the size of the SYN cache. The default is 1000 slots. The
        maximum is 9999 slots, which together with a 10 second
        lifetime would cope with 999 SYNs per second.

        "TC[p] C[ache] S[tatus]" displays the status and statistics
        of the SYN cache.

        "TCP L[isteners]" displays the IP addresses and TCP port
        numbers for the listener (server) sockets that XRouter is
        using on both its own stack and the operating system's.
        An IP address of 0.0.0.0 indicates that the socket is
        listening on all of XRouter's IP addresses.

        "TCP R[eset] <sock#> is used to reset (close) the connection
        whose socket number is specified by <sock#>. This would
        typically be used to close a malicious or "stuck" connection.
        The socket number may be obtained by the STATUS subcommand.

        "TCP S[tatus]" displays the status of all the current TCP
        connections.

        The display shows the socket number, the remote and local 
        addresses, the state, and the amount of queued data in bytes. 
        The states are as follows (see RFC793):

               0    Closed              6    FINWAIT2
               1    Listen              7    Close wait
               2    SYN sent            8    Closing
               3    SYN Received        9    Last ACK
               4    Established         10   Time Wait
               5    FINWAIT1

        TCP S[tatus] <sock#> displays detailed status of the single
        connection identified by <sock#>.

        TCP STATS shows cumulative statistics for the entire TCP
        subsystem. It is equivalent to the "S[tats] TCP" command.

SEE ALSO
        STATS(1) -- Display XRouter statistics.
        UDP(1) -- Display UDP status

TCP(1)                        END OF DOCUMENT

