TDR(9)                  XROUTER REFERENCE MANUAL            21/10/2023

NAME
        TDR -- Time Dependent Routing.

DESCRIPTION
        Conventional NetRom makes routing decisions based on a fairly
        arbitrary metric, i.e. the "route quality", which is assigned
        by sysops, and disseminated in nodes broadcasts.  There is no
        standard for assigning quality, and not only will each sysop
        have a different notion of the quality of his links relative
        to others, but he will probably wrongly assign the qualities
        of those links relative to each other.  This leads to
        inconsistency and distorted routing.

        XRouter includes two systems which attempt to alleviate this
        problem, namely Automatic Quality Measurement" (Autoqual)
        and "Time Domain Routing" (TDR).  Both systems rely on a
        slightly different understanding of the "goodness" of a link.

        In the better-managed parts of the NetRom network, route
        qualities tend to be assigned according to the baud rate of
        the link, with adjustments for retry rates, duplex / simplex
        and shared channels (in the worst-managed parts, route
        qualities are simply assigned to 192 regardless of how good
        or bad the link is).  The quality is fixed at a compromise
        value.

        But the actual "goodness" of a link may continually change
        with atmospheric conditions, data throughput, other channel
        activity, QRM etc.  At certain times of day for example, it
        may be better to use an alternative link.

        A more accurate notion of "goodness" is simply the "Round
        Trip Time" (RTT) for the link, i.e. the time taken to send a
        packet and get a reply.  After all, this is what *really*
        matters to users. A link which responds quickly (i.e. with a
        low RTT) is perceived by users to be better than a link which
        responds slowly.  The RTT will track changes in retry rate,
        channel loading etc.

        The RTT can be easily and consistently measured by software
        on a continuous basis, thus the "quality" of the link is
        accurately known at all times, and all routers of the same
        type will give comparable values independently of the sysop's
        notions of quality.

        XRouter continually measures RTT and uses it to calculate
        a notional "route quality".  This quality is displayed by the
        "R Q" command, and can either be used as a guide to allow the
        sysop to fix the RQ at a sensible value, or XRouter can use
        it dynamically, by setting the route to use Autoqual.
        (Autoqual is engaged by setting an RQ between 256 and 511).
        This RTT to quality conversion is tailored to the British
        notion of quality, which gives somewhat lower but more
        meaningful qualities.

        Autoqual is merely a tool to help sysops set consistent and
        meaningful route qualities. The qualities are still under
        sysop control, thus open to distortion.

        However, by simply broadcasting RTT values instead of
        qualities, the influence of the sysop is removed, and a
        network based on indisputable *times* rather than arbitrary
        *quality* can be created.  This is a network which has its
        routing metric in the time domain, hence the name "Time
        Domain Routing".  It may to some extent overlap the
        quality-domain network, but the boundaries may be different,
        and the two schemes are not compatible. Consider them to be
        different dimensions, at 90 degrees to each other.

        XRouter implements both time-domain and quality-domain
        routing schemes, and will consider information from both
        domains when making routing decisions.  The same node table
        is used for both schemes, since only the metric is different.
        In some cases a node may have both quality and time metrics.

        As sysop, you have several tools at your disposal for
        controlling the size and balance of the two domains.  For the
        quality domain you have QUALITY which defines the "goodness"
        of the links to your neighbours and the "de-rating" of the
        qualities which they send to you, MINQUAL, which determines
        which nodes get into the nodes table and which are excluded,
        MINTXQUAL, which determines how much information you send to
        your neighbour nodes, and MAXNODES which determines the
        maximum number of nodes visible to you.

        For the time domain, you have MAXTT, which defines the
        furthest node in "Trip Time" (i.e. RTT/2) terms, MAXHOPS
        which defines the furthest node as a function of the number
        of intervening nodes, and MAXNODES as above.

        You may adjust these parameters to favour one domain over the
        other, to exclude one domain altogether, or to strike a
        balance between the number of nodes which exist solely in one
        domain or the other.

        For example, setting MAXTT or MAXHOPS to 0 will exclude all
        time-domain information, and Xrouter will behave as a pure
        old-fashioned NetRom router.  Or you may set MINQUAL to 255,
        excluding all quality-domain information (e.g. if there is a
        nearby node distorting the netrom qualities), providing of
        course you have neighbours which are cabable of time-domain
        routing.  Or you may wish to limit the visibility of a subnet
        from one port (e.g. to a foreign network) by setting a low
        MAXHOPS or MAXTT on that port only.  This gives you control
        which was not possible by quality alone.

        XRouter currently (but see compatibility issues) uses the
        INP3 protocol to disseminate time-domain routing information.
        Unlike NetRom, which uses unconnected-mode "broadcasts" to
        all neighbours simultaneously, INP3 sends data to each
        neighbour individually, using connected-mode.  Whilst it is
        usual to make NetRom nodes broadcasts at 1 hour intervals,
        INP3 updates are sent every 10 minutes, with additional
        updates whenever changes occur.

        The time-domain network thus responds much more rapidly to
        changes than NetRom does, but if the network is unreliable
        (i.e. frequent outages and variable RTT's), a lot of updates
        are generated.  Although INP3 updates are more compact than
        NetRom nodes broadcasts, some sysops may feel that the amount
        of routing information is too much for a poor quality RF link.
        If so, you may disable INP3 completely by setting the route
        MAXTT to 0, or you can agree a low MAXTT with your neighbour
        node, which will reduce the volume of data.

        You may notice that nodes which are learned solely via INP3
        are all stored with a NetRom quality of 0. This is deliberate,
        because these nodes have no presence in the quality domain.

        Compatibility issues:

        Although this is a router manual, not a treatise on advanced
        networking, it must be stressed that time-domain and
        quality-domain metrics are incompatible, and information
        learned from one domain must *never* be "translated" and
        broadcast to the other.  XRouter measures, uses and
        disseminates both time and quality metrics, but always keeps
        them separate.

        Unfortunately, *some* software (which shall henceforth be
        known as "Brand-X") *does* translate information between the
        domains, and you should be aware that this may cause you
        problems if they are within the horizon of either domain.

        For example, in the diagram below, imagine that an XRouter
        node (Xr) measures the trip time (TT) to one of its neighbour
        nodes (A) as 1.5 seconds, and the sysop has assigned a Netrom
        quality of 180.

                     180
                   A ---- Xr ---- Bx
                           \     /
                             \ /
                              C ---- D


        XRouter broadcasts both pieces of information to neighbour
        node (Bx) which is using "Brand-X" software.  That software
        ignores the 180 and will instead manufacture a quality of 253
        from the trip time, using a totally unsuitable algorithm.
        By itself this isn't a problem, until the "Brand-X" node
        broadcasts it to node (C) which is NetRom-only.  Now the
        NetRom node thinks it has a higher quality to (A) via (Bx)
        than via (Xr).  So packets from (C) to (A) will now take the
        longer path.  What's worse, (Bx) will tell (Xr) that it knows
        a better route to (A), and the network will decend into chaos.

        A fully interconnected mesh network is very robust, yet the
        "Brand-X" sysops seem remarkably reluctant to implement links
        which result in a mesh.  Maybe the above explains why!

        Another problem occurs when the "Brand-X" software translates
        in the other direction, i.e. it takes a NetRom quality, which
        is a potentially unreliable piece of information, and
        magically turns it into a trip time and hop count. Yet
        neither trip time nor hop count can ever be inferred from
        quality alone!

        The consequence is that a node which exists only in the
        untrustworthy quality domain, and may have been beyond our
        horizon in that domain, now appears in the more trusted time
        domain where it can bypass the NetRom de-rating process.  The
        information could subsequently pass innocently back into the
        Netrom network with a higher "quality" than it would have
        if received via a more direct pure netrom route.

HISTORY
        Early versions of XRouter used a proprietary protocol to
        exchange RTT, hops, IP routing, position and other
        information between themselves.  It was later decided to
        adapt XRouter for INP3 compatibility, believing that it would
        be a good idea to interconnect XRouter's time domain scheme
        with other types of node.

        In hindsight this proved to be a mistake, and it is firmly
        believed that, unless the "Brand-X" software authors correct
        the errors, XRouter and the Netrom network should not be
        connected to any other network which includes "Brand-X"
        nodes. Fortunately, those nodes are now in decline, and BPQ
        is becoming more prevalent. BPQ32 does (correctly) keep time
        and quality domains separate.

SEE ALSO
        AUTOQUAL(9)  -- Automatic Route Quality.
        INP3(9)      -- Inter-Node Protocol 3
        MINQUAL(1)   -- Minimum Quality.
        MINTXQUAL(1) -- Minimum Quality to Transmit.
        ROUTES(1)    -- Add, Drop and List Routes.
        QUALITY(1)   -- NetRom Route Quality.

TDR(9)                      END OF DOCUMENT
