;***********************|****** Max Width *****|*********************|
TELNETPORT(7)           XROUTER REFERENCE MANUAL             27/9/2023

NAME
        TELNETPORT -- TCP Port for TELNET Access.

SYNOPSIS
        TELNETPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        TELNETPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        for TELNET access to XRouter. If not present, the default is
        23.

OPTIONS
        If a single argument is supplied, e.g. "TELNETPORT=23", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "TELNETPORT=23 8023",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting TELNETPORT to zero on a stack prevents TELNET
        access via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        TELNET(9)      -- About TELNET Access.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

TELNETPORT(7)           END OF DOCUMENT
