;***********************|****** Max Width *****|*********************|
TELPROXY(9)             XROUTER REFERENCE MANUAL             27/9/2023

NAME
        TELPROXY -- Telnet Proxy Server.

DESCRIPTION
        The need may arise for a TCP/IP host on the LAN to connect
        first to XRouter, before making an ongoing connection from
        Xrouter to a target host.  Using normal telnet port 23 for
        this purpose is not always successful, especially if the
        link is required to carry binary data, due to the internal
        end-of-line translations and Telnet command sequences which
        are part of the Telnet protocol.

        The Telnet proxy on TCP port 2323 provides a solution to
        this problem, allowing 100% binary connections not only to
        TCP/IP targets, but also to Netrom and AX25 targets. This
        would typically be used by a TCP/IP-only BBS to perform
        FBB compressed forwarding with netrom and ax25 targets.

        Upon connection to port 2323, the caller may, or otherwise,
        be required to answer a security challenge, according to the
        security criteria specified in ACCESS.SYS.  The options are:
        no challenge, callsign only, or callsign plus password, and
        all of these can be made dependent on the caller's IP source
        address.

        If a password is required, it should be located in file
        USERPASS.SYS.

        After gaining entry, the user is presented with a short text 
        explaining the syntax for the outgoing connection, followed
        by a short prompt ">".  This text is read from file
        TELPROXY.MSG, so you may adjust it to your requirements.
        The user may now issue a telnet, netrom or ax25 downlink
        connect command.  XRouter will respond with "Trying ...".

        If the downlink is successfully made, connection is reported,
        then the stream becomes pure binary for the remainder of the
        session.

        If the downlink fails to connect, an error message is sent
        before the uplink is terminated.

FILES
        ACCESS.SYS controls the access requirements for the server.
        TELPROXY.MSG provides an optional alternative login message.
        TELPROXY.ACL controls which targets can be connected to.
        USERPASS.SYS contains the user passwords, if required.

        If required, these files must reside in the same directory
        as the XRouter executable.

SEE ALSO
        ACCESS.SYS(8)   -- Telnet Access Control File.
        TELPROXY.ACL(8) -- Telnet Proxy Egress Control File.
        TELPROXY.MSG(8) -- Telnet Proxy Logon Message File
        TELPROXYPORT(7) -- TCP Port for Telnet Proxy.
        USERPASS.SYS(8) -- User Passwords File.
        
TELPROXY(9)               END OF DOCUMENT
