;***********************|****** Max Width *****|*********************|
TELPROXYPORT(7)         XROUTER REFERENCE MANUAL             27/9/2023

NAME
        TELPROXYPORT -- TCP Port for Telnet Proxy.

SYNOPSIS
        TELPROXYPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        TELPROXYPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        for Telnet proxy access to XRouter. If not present, the
        default is 2323.

        The Telnet proxy allows 100% binary connections not only to
        TCP/IP targets, but also to Netrom and AX25 targets. This
        would typically be used by a TCP/IP-only BBS to perform
        FBB compressed forwarding with netrom and ax25 targets.

OPTIONS
        If a single argument is supplied, e.g. "TELPROXYPORT=2323",
        it applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "TELPROXYPORT=236 2323",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting TELPROXYPORT to zero on a stack prevents Telnet
        proxy access via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        TELPROXY(9)    -- About the Telnet Proxy.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

TELPROXYPORT(7)           END OF DOCUMENT
