;***********************|****** Max Width *****|*********************|
TNC2(9)                 XROUTER REFERENCE MANUAL             28/9/2023

NAME
        TNC2 -- TNC2 Emulator.

DESCRIPTION
        The TNC2 Emulator is a feature which allows RS232 devices
        such as weather stations, dumb terminals, GPS and telemetry
        devices to send and receive packets as if they were connected
        to a real TNC2.


                \|/            .---------.
                 |   .-----.   |         |         .-----.
                 '---| Rig |---| XRouter |----<----| GPS |
                     '-----'   |         |  RS232  '-----'
                               '---------'

        For example, imagine you have a weather station which is
        designed to be connected to a TNC via an RS232 cable.  Now
        imagine that you already have an APRS port on your XRouter.
        How would you get your weather station on air?

        You *could* use an additional TNC, radio and antenna, but that
        would be a pointless duplication of equipment.  Far better to
        configure XRouter to emulate a TNC, so that it can interface
        directly to the weather station. This allows the weather
        station to send to, and receive from, the existing APRS port.

        Or you may have a dumb terminal connected to XRouter via an
        RS232 cable, and use it to monitor any port, make connections
        with other stations etc.  This is completely independent of
        XRouter's command interface, and does not require a session
        with the node.

        There are several applications which have TNC2 as one of the
        interface options. You may interface them to any of XRouter's
        radio ports via that means.

        Or perhaps you wish to monitor a radio channel with a data
        logging program, or send the channel activity to a serial
        printer?  The possibilities are limited by your imagination.

        Configuration
        ~~~~~~~~~~~~~
        The emulator requires only an INTERFACE in XROUTER.CFG. It
        does *not* require a PORT. It is usually configured by
        defining an INTERFACE with TYPE=ASYNC and PROTOCOL=TNC2.
        Choose SPEED to suit the peripherals, and MTU=256.

        Example:

           INTERFACE=5
                TYPE=ASYNC
                COM=1
                SPEED=19200
                PROTOCOL=TNC2
                MTU=256
           ENDINTERFACE

        You can have as many TNC emulators as you wish, providing you
        have an RS232 port for each one.  You should preferably use a
        different MYCALL or SSID for each one if there is any chance
        of more than one TNC being used on the same radio port.

        In addition to TYPE=ASYNC, You may also use the TNC2 protocol
        over a TYPE=UDP or TYPE=TCP interface.

        Operation
        ~~~~~~~~~
        Standard TNC2 commands currently recognised are Ctrl-C,
        AUTOLF, CONNECT, CONVERSE, DISCONNECT, DISPLAY, ECHO, FLOW,
        HELP, HEADERLN, KONVERSE, MALL, MCOM, MCON, MONITOR, MRPT,
        MSTAMP, MYCALL, PORT, PORTS and UNPROTO. Other commands may
        be implemented upon request.

        You may set the TNC's callsign (using MYCALL) completely
        independently of XRouter's callsign, and may select any of
        XRouter's radio ports using the PORT command. When you select
        a port, the TNC2 emulator receives from, and transmits to,
        the radio equipment connected to that port. 

        All settings are saved to the file TNCn.CFG where 'n' is the
        interface number.  This file is automatically created if it
        doesn't already exist.  It is read when XRouter starts up,
        so the TNC always returns to its previous configuration.  The
        file contains binary data, so you must not attempt to edit it.

NOTES
        The emulator does not currently accept incoming connections.
        That facility may be added upon request.

SEE ALSO
        TCP-IFACE(6)   -- Interface type TCP.
        UDP-IFACE(6)   -- Interface type UDP.
        WA8DED(9)      -- WA8DED TNC Emulator
        XROUTER.CFG(8) -- Main Configuraion File

TNC2(9)                   END OF DOCUMENT
