TRACERT(1)              XROUTER REFERENCE MANUAL            19/10/2023

COMMAND
        TRACERT -- Trace Route to TCP/IP host.

SYNOPSIS
        TR[acert] <host> [maxhops [maxwait(ms)]]

DESCRIPTION
        The TRACERT command is a diagnostic tool for displaying the
        route to an Internet Protocol host, and measuring the transit
        delays of packets at each step.

        It uses the replies from a series of ICMP echo requests to
        produce a list of the routers that the packets have passed
        through.

        3 attempts are made at each hop, thus for each hop, 3 round
        trip times are displayed, along with the IP address of the
        router at that hop. The 3 times indicate the consistency of
        the route. If no response is received within the timeout
        period, a "*" is displayed in the time field.

OPTIONS
        <host> is the hostname or IP address of the target host.

        [maxhops] is the maximum number of hops to trace (default 30).

        [maxwait] is the maximum time to wait for a reply from each
                  router. The default is 4 seconds.

        The only required parameter is <host>. If the hostname
        doesn't contain at least one dot (.) the domain suffix
        specified in XROUTER.CFG (default .ampr.org.) is appended.

        Entering TRACERT without any arguments displays a syntax
        reminder.

EXAMPLES
        TR bbc.co.uk       - Trace bbc.co.uk with default parameters.
        TR 44.141.91.2 10  - Trace 44.131.91.2 to a max of 10 hops.
        TR g8pzt 5 20      - Trace g8pzt.ampr.org, 5 hops, max 20secs.

            G8PZT-12:PZT12} Tracing route to g8pzt [44.131.91.4],
            max. 5 hops

             1      0 ms     0 ms     0 ms   [44.131.91.246]
             2      0 ms    55 ms    55 ms   [44.131.91.245]
             3    165 ms    55 ms    55 ms   [44.131.91.4]

             Trace complete.

CAVEATS
        TRACERT relies on ICMP messages, and therefore requires that
        ICMP is correctly routed via front-end routers and firewalls
        etc. It will fail to produce a response from systems that are
        "stealthy" i.e. those that do not respond to ICMP. Such
        systems are indicated by "* * * Request timed out" lines.

        The Traceroute function will not work unless XRouter has an
        IP address, and IP routing has been correctly set up.

AVAILABILITY
        All users.

SEE ALSO
        IP(1)      -- IP Configuration Commands
        PING(1)    -- Send ICMP Echo request
        STEALTH(9) -- TCP/IP Stealth Issues

TRACERT(1)                  END OF DOCUMENT
