;***********************|****** Max Width *****|*********************|
TTYLINK(9)              XROUTER REFERENCE MANUAL             27/9/2023

NAME
        TTYLINK -- Keyboard To Keyboard Chat.

DESCRIPTION
        TTYLINK is private real-time keyboard-to-keyboard chat
        between sysops, which doesn't involve the CHAT server.

        The TTYLINK server listens for incoming connections on TCP
        port 87 (see TTYLINKPORT) and NetRomX service 87.

        Client sessions are initiated by:

           (a) telnetting to TCP port 87 on the target system,
        or (b) using "TT[ylink] <target_ip>",
        or (c) using "C <nodecall | nodealias> 87"
        or (d) using "TALK <nodecall | nodealias>"
        or (e) using "NTTY <nodecall | nodealias>"

           (Options (c) (d) and (e) require that the target is a
            reachable NetRomX node)

        Upon receiving a connection from a client, the server "pages"
        the sysop, who has 90 seconds to respond. The paging consists
        of a pop-up dialog on top of the sysop's current window, and
        an audible sound (Note: unless AUDIODEVICE is defined, the
        sound only works on older-style PC's which have an internal
        loudsqueaker). The server also sends this to the client:

            TTYLINK at MOBILE:G8PZT-1
            Calling sysop for 90 seconds..
            Type 'M' at any time to leave a short message,
             or 'Q' to quit...

        At any point during or after the 90 seconds, the client has
        the option to leave a short one-line message (160 chars max)
        or to abort the call.

        Here's an example where the sysop responded:

            *** G8PZT-1 has come online to talk ***
            Hello, why are you calling me?
            Because I want to, silly!
            Fair enough, it's mad talking to oneself you know...
            I know, but no-one else is around.
            Ok, bye for now

            *** The other end terminated the chat

        If the sysop takes more than 90 seconds to respond, and the
        client has not disconnected, the sysop can still use the
        TALK command to initiate a chat with the caller.

        Here's an where the sysop didn't respond. Although not
        strictly TTYlink, it is a useful compromise, rather than
        allow an important call to be missed:

            TTYLINK at MOBILE:G8PZT-1
            Calling sysop for 90 seconds..
            Type 'M' at any time to leave a short message,
             or 'Q' to quit...
            No response, please type a short (1 line) message now...
            (or enter a blank line to skip this step)

            Can you call me back to discuss xrpi release asap? 

            Message saved for sysop
            Goodbye

        The message is stored in the sysop's PMS, and a flashing
        asterisk on the top left corner of the status bar alerts the
        sysop to its presence. The sysop can then access their PMS
        to read the message like this:

            CMD(B/H/K/L/R/S/?)>
            l
            Msg# Stat  Rcvd  Time  To      From    Subject
            6 PR   22/05 03:25  SYSOP   G8PZT   TTYLink msg from
                                                 G8PZT@VK2DOT-1

            CMD(B/H/K/L/R/S/?)>
            r 6

            Msg#: 6
            Rcvd: 22/05 03:25
            From: G8PZT
            To:   SYSOP
            Subj: TTYLink msg from G8PZT@VK2DOT-1

            Can you call me back to discuss XRPi release asap?

            CMD(B/H/K/L/R/S/?)>

        It's all a bit untidy at present, but will hopefully be
        tidied up in future revisons.

SEE ALSO
        NTTY(1)        -- Netrom TTYLink.
        TALK(1)        -- Talk to a user or another sysop.
        TTYLINK(1)     -- Keyboard chat with another TCP/IP system.
        TTYLINKPORT(7) -- TCP Port for TTYLINK Server.
        AUDIO(9)       -- Audio Output.
        SERVICES(9)    -- NetRomX Standard Services.

TTYLINK(9)                  END OF DOCUMENT
