;***********************|****** Max Width *****|*********************|
TTYLINKPORT(7)          XROUTER REFERENCE MANUAL             27/9/2023

NAME
        TTYLINKPORT -- TCP Port for TTYLINK Access.

SYNOPSIS
        TTYLINKPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        TTYLINKPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        for TTYLINK (keyboard to keyboard chat) access to XRouter. If
        not present, the default is 87.

        TTYLINK is also available as NetRomX service 87.

OPTIONS
        If a single argument is supplied, e.g. "TTYLINKPORT=23", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "TTYLINKPORT=87 8087",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting TTYLINKPORT to zero on a stack prevents TTYLINK
        access via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        TTYLINK(9)     -- About TTYLINK.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

TTYLINKPORT(7)           END OF DOCUMENT
