;*************************** Max Width *******************************
TUN-IFACE(6)           XROUTER REFERENCE MANUAL               6/9/2023

NAME
        TUN-IFACE -- Tunnel Interface.

DESCRIPTION
        The Linux "tun" interface provides a means of IP-layer
        communication between user-space programs such as XRouter,
        and the Linux kernal IP stack.

        It is a purely software interface; there is no hardware
        involved.

        Tunnels may be "transient", or "persistent".

        A transient tunnel is one that is created, used and destroyed
        by the same program. It ceases to exist when the program
        closes.

        A persistent tunnel is one that is created from the Linux
        command line using a command such as this:

              "ip tuntap add mode tun dev tun7".

        Programs can attach to, and detach from, a persistent tunnel
        at will. The tunnel is not destroyed when the user-space
        program closes.

        XRouter can use either type of tunnel.

        Tunnels may only be created or modified by root users, or
        those with CAP_NET_ADMIN capability.


        Usage Cases:
        ============

        In most cases, XRouter communicates with the outside world
        either via the Linux TCP/IP stack, via its own TCP/IP stack,
        or via serial RS232 interfaces.

        It can also be set up to allow PING, TELNET, FTP, HTTP etc
        from Linux to XRouter, and to access Linux services from
        XRouter. But those interactions are done at a layer ABOVE the
        network layer. There is normally no IP-layer communication
        between XRouter and the Linux TCP/IP stack. I.e. you can't
        normally send an IP datagram from XRouter to Linux or vice
        versa.

        (Note: It is possible for XR32 to do this on Windows when
        using the NDIS driver to share the Ethernet NIC. But Linux
        appears to ignore XRouter's Ethernet frames that are sent on
        a shared NIC because the source and destination hardware
        addresses are the same. Maybe there's a fix for this?)

        Because of the above, direct IP routing between XRouter and
        other programs on the same Linux machine is not possible.

        Usually this can be circumvented using AXIP, AXUDP or IPUDP
        via the Linux localhost address space. But some programs,
        e.g. JNOS, don't seem able to access that space.

        Another alternative would be to use SLIP, but that
        functionality has been withdrawn from Linux and JNOS.

        This is where an IP tunnel can be used.

OPTIONS
        Configuring a Tunnel Interface on XRouter:
        ======================================

        Using a Persistent Tunnel
        ~~~~~~~~~~~~~~~~~~~~~~~~~

        Let's say the tunnel's name is "tun99" and it has the
        "address" 192.168.0.100 and "destination" 192.168.0.99. The
        former is the IP address of the Linux end, and the latter is
        the XRouter end.

        In XROUTER.CFG, define an interface with TYPE=TUN and
        COM=tun99 like this:

            INTERFACE=1
                ID=Tunnel to Linux
                TYPE=TUN
                COM=tun99
                PROTOCOL=IP
                MTU=1500
            ENDINTERFACE

        Then attach a single port to that interface, with an IP
        address that matches the *destination* address of the tunnel.
        (If the addresses don't match, XRouter will not receive
        frames!).

            PORT=3
                ID="Tunnel"
                INTERFACENUM=1
                ipaddress=192.168.0.99
            ENDPORT

        Finally, add some routing to IPROUTE.SYS, so XRouter knows
        where to send IP datagrams. For example:

            IP ROUTE ADD 192.168.0.0/24 192.168.0.100 3 d

        That routes all of 192.168.x.x to the gateway 192.168.0.100,
        whch is at the "far" end of the tunnel from XRouter's point
        of view.


        Using a transient tunnel:
        ~~~~~~~~~~~~~~~~~~~~~~~~~

        In this case the tunnel is created and named by XRouter, and
        lasts only until XRouter is closed.

        The XRouter interface and port are defined in the same way as
        for the persistent tunnel, but a few variations are possible.

        In all cases, the IP address for the "local" (XRouter) end of
        the tunnel is specified by IPADDRESS in the PORT block, and
        you will needs to set up a suitable route in IPROUTE.SYS.

        a) Simple Method

        If you add IOADDR keyword to the INTERFACE block (see below),
        it specifies the IP address at the *far* (Linux) end of the
        tunnel. XRouter will create the tunnel and set both addresses:

            INTERFACE=3
                ID=Tunnel to Linux
                TYPE=TUN
                COM=tun99
                PROTOCOL=IP
                IOADDR=192.168.0.98 <--- Add this line
                MTU=1500
            ENDINTERFACE


        b) Manual Method

        If you OMIT the IOADDR keyword, you are responsible for
        setting up the addresses at BOTH ends of the tunnel, and for
        bringing it "up" (online).

        You can do this manually, by typing commands into a Linux
        terminal after XRouter has started, or you can put "shell"
        commands in BOOTCMDS.SYS like this:

        # Assign the address 192.168.0.98 to the Linux end of tun99:
        shell ip address add 192.168.0.98 dev tun99
        ;
        # Wait 300 millisecs for Linux to execute the command
        wait 300
        #
        # Tell Linux that 192.168.0.99 is on the other end of tun99:
        shell ifconfig tun99 dstaddr 192.168.0.99
        #
        wait 300
        #
        # Bring up the Linux end of the interface:
        shell ip link set dev tun99 up
        #

        There are many ways in Linux of achieving the same results,
        for instance (all on one line):

            ifconfig tun99 192.168.0.98 pointopoint 192.168.0.99
               mtu 1500 up

SEE ALSO
        IFACES(6)       -- Interfaces in XRouter.
        CAPFLAGS(6)     -- Capability Flags.
        PORTS(6)        -- Ports in XRouter.
        BOOTCMDS.SYS(8) -- Boot-time commands
        XROUTER.CFG(8)  -- Main Configuration File.

TUN-IFACE(6)                  END OF DOCUMENT
