;*************************** Max Width *******************************
TXDELAY(7)             XROUTER REFERENCE MANUAL              26/9/2023

NAME
        TXDELAY -- Transmit Delay.

SYNOPSIS
        TXDELAY=<millisecs>

DESCRIPTION
        TXDELAY is an optional PORT directive used in XROUTER.CFG.

        It specifies the delay between transmitter activation and the
        start of the frame data in milliseconds (default=300).

        After turning the transmitter on, the TNC (or SCC / YAM card)
        waits for this interval before sending HDLC data. This allows
        the TX to stabilise, and the link partner's squelch to open.

        The value can be changed on the fly using the TXDELAY
        command, but please be ware that changes may take up to 5
        minutes to take effect on KISS TNC's.

NOTE
        Software TNC's such as "Direwolf" might complain that your
        TXDELAY setting is too long, but they have no knowledge of
        how long it takes the transmitter frequency to stabiise, nor
        how long it takes the link partnar's squelch to open, so you
        should ignore it and trust your own judgement!

        Start with a long TXDELAY, e.g. 500 millisecs, then gradually
        reduce it until the partner stops responding. That is the
        absolute minimum txdelay. Raise TXDELAY until the link
        becomes reliable again. Stupidly low TXDELAY is a common
        cause of erratic links! Don't forget that the radios may be
        inconsistent - they might be slower to respond when cold or
        hot, or when desensitised by other signals.

SEE ALSO
        TXDELAY(1)     -- Display / Set TX Delay.
        PORTS(6)       -- Ports in XRouter.
        TXTAIL(7)      -- TX Tail Time
        XROUTER.CFG(8) -- Main Configuration File.

TXDELAY(7)                  END OF DOCUMENT
