;*************************** Max Width *******************************
TXDELAY(1)            XROUTER REFERENCE MANUAL               26/9/2023

COMMAND
        TXDELAY -- Display / Set Port Transmit Delay.

SYNOPSIS
        TXD[ELAY] <port> [millisecs]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The TXDELAY command allows the value of the transmit 
        delay for a port to be displayed or altered. This is the
        interval between the transmitter being activated and the
        start of a transmitted packet. (see NOTES).

        Any changes made by this command override the settings
        specified in the PORT sections of XROUTER.CFG, and remain in
        force only until XRouter restarts.

        On KISS TNC's, you should allow up to 5 minutes for any new 
        setting to take effect.

OPTIONS
        If a single numeric argument is supplied, the current value 
        for that port number is displayed.

        If two numeric arguments are supplied, the first specifies the 
        port number, and the second specifies the new value for the 
        parameter in milliseconds.

EXAMPLE
        TXDELAY 3       - Display current setting for port 3
        TXDELAY 3 300   - Set port 3 txdelay to 300 millisecs

NOTES
        TXDELAY is the interval between transmitter activation 
        and the start of a transmitted packet.  It allows time for the 
        RF to reach its full value, and for the TX audio circuits to 
        stabilise.  Some synthesised rigs require a large txdelay (500 
        or more) to allow the synthesiser to swing between RX and TX 
        frequencies, and many rigs have audio stages which take 100 ms 
        to stabilise while oversized electrolytics charge up.

        One factor which is often overlooked is the other end's 
        receiver.  It takes a finite time for the squelch to open, and 
        if the rig has just been transmitting it may take a while to 
        stabilise back to receiving, especially with synthesised rigs.
  
        If your txd is too short, you will be sending replies before 
        the other end is ready to hear you, and unnecessary retries 
        will result.

        Software TNC's such as "Direwolf" might complain that your
        TXDELAY setting is too long, but they have no knowledge of
        how long it takes the transmitter frequency to stabiise, nor
        how long it takes the link partnar's squelch to open, so you
        should ignore it and trust your own judgement!

SEE ALSO
        TXDELAY(7)     -- Transmit Delay.
        TXTAIL(1)      -- Transmit Tail Time.
        XROUTER.CFG(8) -- Main Configuration File.

TXDELAY(1)                    END OF DOCUMENT
