TXOK(1)                 XROUTER REFERENCE MANUAL            19/10/2023

COMMAND
        TXOK -- Display / Set "ok to tx" for a port.

SYNOPSIS
        TXO[k] <port> [0 - 3]

DESCRIPTION
        Displays the current TXOK flag setting for a port, and allows 
        it to be changed.  This flag controls whether or not the 
        transmitter is allowed to key up, and whether or not the
        receiver is enabled.

        If two numeric arguments are supplied, the TXOK flag is set
        to  the second argument, otherwise the current setting for
        the specified port is displayed.

        Values are:  0 = TX disabled, RX enabled
                     1 = TX enabled,  RX enabled
                     2 = TX disabled, RX disabled
                     3 = TX enabled,  RX disabled

        State 2 would typically be used to disable all traffic on a
        port, to time out troublesome connections, or to do tests.

        By default, all ports have this flag set to 1 (TX and RX
        enabled).

        Modified settings remain in force until changed or system is 
        restarted.

EXAMPLE
        TXOK 3        - Display current setting for port 3
        TXOK 3 0      - Stop port 3 transmissions.

AVAILABILITY
        Requires SYSOP status.

CAVEATS
        It should be obvious, but setting TXOK=0 for the port you are
        using to send commands, will cause you to lose control of the
        node!

        Setting TXOK=0 does not actually disable the transmitter 
        itself, it merely prevents any frames being sent to the TNC, 
        so if the latter has a built-in CWID, it will still key up
        the TX so send the CWID.

TXOK(1)                     END OF DOCUMENT
