;***********************|****** Max Width *****|*********************|
UDP-IFACE(6)            XROUTER REFERENCE MANUAL             28/9/2023

NAME
        UDP-IFACE -- Interface type "UDP".

DESCRIPTION
        Interface type "UDP" allows systems on the same machine, or
        on different machines, to be linked together using various
        protocols tunneled inside UDP datagrams.

        Whilst intended for "frame-delimited" protocols, it has been
        found to work satisfactorily with "stream" protocols, at
        least on the same machine.

        A typical UDP interface would be defined thus:

            INTERFACE=17
                TYPE=UDP
                ID=KISS over UDP
                PROTOCOL=KISS
                IOADDR=127.0.0.1
                INTNUM=9701
                COM=9702
                MTU=256
            ENDINTERFACE

        Note Some keywords are re-purposed to avoid creating new ones!

        TYPE, PROTOCOL, IOADDR, INTNUM, COM and MTU are mandatory.

        ID is an optional text which identifies the interface on
           various displays. Keep it concise. 20 chars max.

        IOADDR specifies the IP address of the target system, i.e.
               the other end of the link. Use 127.0.0.1 if the target
               is on the same machine as XRouter.

        COM specifies the UDP port the target system listens on.

        INTNUM specifies the UDP port that XRouter is listening on.
               If both systems are on the same machine, COM and
               INTNUM *must* be different!!

        MTU specifies the "Maximum Transmission Unit", i.e. the
            maximum payload size for a packet transmitted on the
            interface. The value depends on the protocol.

        PROTOCOL is the protocol to use on the interface:

            ASCII    - Plain text
            AX25     - Plain AX25, no CRC
            ETHER    - Ethernet
            HDLC     - AX25 with CRC, but no HDLC flags
            IP       - Plain IP
            KISS     - Basically AX25 within SLIP
            NETROM   - Netrom backend serial link.
            PPP      - Point to Point Protocol
            SLIP     - Serial Line Internet Protocol
            TNC      - TNC Control
            TNC2     - TNC2 Emulation.

            (see PROTOCOL(7) for more detail)
NOTES
        This interface uses the Linux IP stack, so if INTNUM is below
        1024, XRouter will need CAP_NET_BIND_SERVICE capability, or
        will need to run from a "root" account.

SEE ALSO
        IFACES(6)      -- Interfaces.
        CAPFLAGS(6)    -- Capability Flags.
        KISS(9)        -- KISS Protocol.
        PORTS(6)       -- Ports in XRouter.
        PPP(9)         -- Point to Point Protocol.
        PROTOCOL(7)    -- Protocol Used on INTERFACE.
        TNC2(9)        -- TNC2 Emulation.
        XROUTER.CFG(8) -- Main Configuration File.

UDP-IFACE(6)               END OF DOCUMENT
