UDP(1)                  XROUTER REFERENCE MANUAL            17/10/2023

COMMAND
        UDP -- UDP status and statistics commands.

SYNOPSIS
        UD[p] S[ockets]
        UD[p} ST[ats]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The UDP command is used to display the active UDP sockets,
        their status, and UDP layer statistics.

OPTIONS
        UD[p] S[ockets] display the active UDP sockets, along with
        their local addresses and port numbers, the stack they are
        using, and the number of frames queued for reception. For
        example:

           Sock#  Local_address          Stack    Rxq
          7338e0  0.0.0.0 9701           O/S        0
          733b78  0.0.0.0 9702           O/S        0
          737050  127.0.0.1 10095        O/S        0
          737768  0.0.0.0 10094          O/S        0
          731dc0  0.0.0.0 53             XrLin      0 

        "0.0.0.0" means "any IP address". "O/S" means the socket is
        on the operating system's stack.


        UD[p} ST[ats] produces a display like this:
                                                                                               
             19 Segments sent,    921 bytes
           2178 Segments rcvd, 177583 bytes
              0 Malformed segments rcvd
              0 Segments rcvd with bad checksum
           2160 Unwanted segments rcvd
              0 Broadcast segments
              0 Segments ignored from banned IP's
              0 Attempted Fraggle attacks

        The fields are largely self-explanatory.

        "Malformed segments" are those which are too short to contain
        a valid UDP header.

        "Unwanted segments" is the number of UDP frames received for
        which there was no receive socket.

        "Broadcast segments" is the number of UDP frames whose
        destination IP was the subnet broadcast address.

        A "fraggle attack" is one where an attacker sends a large
        amour of data with spoofed source addresses to the ECHO (7)
        or CHARGEN (19) ports. XRouter does not implement those
        services on UDP, but keeps records so that attacks can be
        detected.

SEE ALSO
        TCP(1) -- Display TCP status

UDP(1)                      END OF DOCUMENT
