;*************************** Max Width *******************************
UDPLOCAL(7)            XROUTER REFERENCE MANUAL              26/9/2023

NAME
        UDPLOCAL -- Local UDP Port for Link.

SYNOPSIS
        UDPLOCAL=<udp_port>

DESCRIPTION
        UDPLOCAL is a PORT directive used in XROUTER.CFG for AXUDP
        ports only.

        It specifies the UDP port number for the local end of an
        AXUDP link. The default is 93. This number must match the
        link partner's UDPREMOTE, i.e. the destination service number
        in the frames from him to you.

        It is perfectly valid for all your PORTS to use the same
        UDPLOCAL. This reduces the number of "holes" (port forwards)
        you need to make in your firewall. The *only* reason ever to
        have more than one UDPLOCAL is when you have more than one
        AXUDP node sharing the same public IP address. Your link
        partners have no right to dictate this value!

EXAMPLE
        UDPLOCAL=7388 

CAVEATS
        If UDPLOCAL is less than 1024, and XRouter is using the Linux
        IP stack, XRouter needs to be granted the CAP_NET_BIND_SERVICE
        capability unless it is run from a root account. See CAPFLAGS
        for more information.

SEE ALSO
        AXUDP(9)       -- AX25-over-UDP Tunnelling.
        CAPFLAGS(6)    -- Capability Flags.
        PORTS(6)       -- Ports in XRouter.
        UDPLOCAL(1)    -- Display / Set Local UDP Port.
        UDPREMOTE(7)   -- Remote UDP Port.
        XROUTER.CFG(8) -- Main Configuration File.

UDPLOCAL(7)                  END OF DOCUMENT
