UDPLOCAL(1)           XROUTER REFERENCE MANUAL               26/9/2023

COMMAND
        UDPLOCAL -- Display / Set a port's UDPLOCAL parameter.

SYNOPSIS
        UDPLOCAL <port> [0-65535]

DESCRIPTION
        The UDPLOCAL command allows the UDP service number (often
        confusingly called a "port") at the local end of an AXUDP
        link to be displayed or altered. 

        This number must match the link partner's UDPREMOTE, i.e. the
        destination service number in the frames from him to you.

        If not specified, UDPLOCAL defaults to 93.

        It is usually specified within a PORT configuration block in
        the XROUTER.CFG file, but this command allows it to be
        changed on the fly, without needing to take XRouter off line.

        Please see the manual section on AXUDP for more information.

OPTIONS
        If a single numeric argument is supplied, the current value 
        for that port number is displayed.

        If two numeric arguments are supplied, the first specifies
        the port number, and the second specifies the new value for
        the parameter.  The new setting remains in force until
        changed, or until XRouter is restarted, in which case the
        value specified in the XROUTER.CFG file is reapplied.

EXAMPLE
        UDPLOCAL 3       - Display current UDPLOCAL for port 3
        UDPLOCAL 3 9393  - Set port 3 UDPLOCAL to 9393

AVAILABILITY
        Sysop-only.

SEE ALSO
        AXUDP(9)       -- AX25-over-UDP Tunnelling.
        UDPLOCAL(7)    -- Local UDP POrt.
        UDPREMOTE(1)   -- Display / Set a port's UDPREMOTE parameter.
        XROUTER.CFG(8) -- Main Configuration File

UDPLOCAL(1)                   END OF DOCUMENT
