UDPREMOTE(1)            XROUTER REFERENCE MANUAL            21/10/2023

COMMAND
        UDPREMOTE -- Display / Set a port's UDPREMOTE parameter.

SYNOPSIS
        UDPREMOTE <port> [0-65535]

DESCRIPTION
        The UDPREMOTE command allows the UDP service number (often
        confusingly called a "port") at the remote end of an AXUDP
        link to be displayed or altered. 

        This is the UDP destination number in the AXUDP frames from
        you to your link partner. It must match the link partner's
        UDPLOCAL, otherwise the link will not function.

        If not specified, UDPREMOTE defaults to 93.  It is only used
        on AXUDP ports.

        It is usually specified within a PORT configuration block in
        the XROUTER.CFG file, but this command allows it to be
        changed on the fly, without needing to take XRouter off line.

        Please see the manual section on AXUDP for more information.

OPTIONS
        If a single numeric argument is supplied, the current value 
        for that port number is displayed.

        If two numeric arguments are supplied, the first specifies
        the PORT number, and the second specifies the new value for
        the  parameter.  The new setting remains in force until
        changed, or until XRouter is restarted, in which case the
        value specified in the XROUTER.CFG file is reapplied.

EXAMPLE
        UDPREMOTE 3       - Display UDPREMOTE setting for port 3
        UDPREMOTE 3 9393  - Set port 3 UDPREMOTE to 9393

AVAILABILITY
        Sysop-only.

SEE ALSO
        AXUDP(9)        -- AX25-over-UDP Tunnelling.
        UDPLOCAL(1)     -- Display / Set a port's UDPLOCAL parameter.
        UDPREMOTE(7)    -- Remote UDP Port for Link.
        XROUTER.CFG(8)  -- Main Configuration File

UDPREMOTE(1)                END OF DOCUMENT
