WA8DED(9)               XROUTER REFERENCE MANUAL            19/10/2023

NAME
        WA8DED -- WA8DED TNC Emulator.

DESCRIPTION
        XRouter can emulate a WA8DED TNC, in both normal mode and
        "host" mode.  Host mode operation is covered in the MAN page
        for DEDHOST.  Normal mode might be used by a human user, or
        by an application designed to work with a WA8DED TNC in this
        mode.

                .---------.                  .-----------.
                | XRouter |------RS232-------| HyperTerm |<--User
                '---------'                  '-----------'


        The user may be located on the same machine as XRouter,
        connected to it either via a pair of "virtual" COM ports, or
        via a pair of "real" COM ports interconnected with a null
        modem cable.

        Alternatively, the user may be located on a seperate machine,
        using an RS232 null-modem cable to interconnect the machines. 


        Configuring WA8DED Emulation
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        The configuration for non-hostmode operation is essentially
        the same as for hostmode, except that an APPL block is not
        required in XROUTER.CFG.  In fact, an interface set up for
        hostmode will work OK in non-hostmode too.

        1) Decide how to interconnect the user and XRouter.

           You can use either a pair of real COM ports and a
           null-modem cable, or a virtual com port driver such as
           Com0Com.

           If using the latter, install it on the PC (if it isn't
           already installed) and note the numbers of the two COM
           ports it provides.  You may need to adjust one or both of
           them to a convenient number for your application.  Ensure
           that "Baud Rate Emulation" and "Enable Buffer Overrun" are
           checked on both sides.


        2) Add an INTERFACE.

           In XROUTER.CFG specify an interface similar to this, where
           "x" represents the interface number...
 
               INTERFACE=x
                    TYPE=ASYNC
                    COM=18
                    PROTOCOL=DEDHOST
                    CHANNELS=4
                    SPEED=9600
                    FLOW=0
                    MTU=256
               ENDINTERFACE

           COM is the number of one of the real or virtual COM ports
           used to connect with the application.  XRouter can use COM
           numbers up to COM32. On Linux, COM is a TTY device name.

           CHANNELS specifies the max no. of host channels the
           interface will provide (between 1 and 32). The total
           number of host channels available to be shared between all
           applications is 64. If XRouter cannot allocate the
           requested number of channels it will fail to start. (In
           versions up to 200e the number of channels was specified
           by INTNUM. This is now deprecated.) 

           MTU must be 256 

           SPEED is the serial baud rate.

           FLOW must always be set to 0. 

           - Don't use CHANNEL, IOADDR, or INTNUM keywords. 

           - Don't try to attach any PORTs to this interface, as they
             are not required. 


        Using WA8DED TNC Emulation in Terminal Mode
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        XRouter's WA8DED emulator starts up in "terminal" mode (i.e.
        not host mode) and may be therefore tested or used in this
        mode using Hyperterm or any other dumb terminal. Wherever
        possible, the emulator behaves the same as a "real" WA8DED
        TNC, as detailed below: 

        In normal mode, commands and information are sent from the
        terminal to the emulator in the form of lines. Lines may be
        up to 256 characters long, including the terminating CARRIAGE
        RETURN.  If the 256th character entered is not a CARRIAGE
        RETURN, it will be discarded and a BELL character will be
        output to the terminal. BACKSPACE and DELETE may be used to
        remove single characters from the line. The entire line may
        be permanently backspaced out by entering a CONTROL-U or
        CONTROL-X. 

        Lines which begin with an ESCAPE character (echoed as '* ')
        are interpreted as commands. Lines without a leading ESCAPE
        character are sent as information. 

        Most commands consist of a single letter. Some commands have
        an optional parameter. The number of spaces (if any) between
        the command and any parameter is not important. If a command
        is issued with no parameter, the current value of that
        command's parameter is displayed. Unless a parameter is
        returned, commands don't normally return any acknowledgement. 

        By default, XRouter's WA8DED emulator provides the operator
        with five virtual TNC channels, numbered 0 to 4 (The actual
        number may be altered between 1 and 32 using the CHANNELS=
        keyword in the supporting INTERFACE).  The terminal is
        logically attached to only one of these channels at a time,
        selected by the 'S' command. 

        Channel 0 is reserved for unproto transmissions and
        monitoring.  This channel does not support connections.
        Information sent on channel 0 is always unproto.  The unproto
        path may be set by issuing a 'C' command when channel 0 is
        selected. 

        Channels other than 0 support connections, but are unproto if
        they are not currently connected.  Outgoing connect requests
        may be issued on any unconnected channel (other than channel
        0), while incoming connect requests will use the first
        available channel (provided the maximum number of connections
        set by the 'Y' command will not be exceeded). 

        Information received on a connected channel that is not
        currently selected will remain queued there until that
        channel is selected.  The 'L' command may be used to
        determine the channel(s) where stored information is located.

        Information for transmission is sent only to the currently
        selected channel.  When a connection is ended, received
        information will remain queued until it has been displayed. 

        Frame monitoring is controlled by the 'M' command.  The
        command parameter determines the types of frames monitored,
        and is a list of desired frames chosen from the letters in
        the following table: 

               LTR       FRAME
               ---       -----
                N        None
                I        I frames
                U        UI frames
                S        Supervisory frames
                C        Monitor while connected
                +        Call signs to be included (maximum of 8)
                -        Call signs to be excluded (maximum of 8)


        The '+' and '-' parameters may not be used together. If
        either is used, it must be the last parameter (followed by
        one to eight callsigns, if applicable).  If no list of
        callsigns is specified to be included or excluded, all
        callsigns will be candidates for monitoring.  Entering a '+'
        or '-' with no callsigns clears the list. 

        An asterisk displayed after a callsign in the digipeater list
        indicates the frame was transmitted by that station.  The
        control field displayed will be one of the following: 

               NAME   DESCRIPTION
               ----   -----------
               RRa  - Receive Ready
               RNRa - Receive Not Ready
               REJa - Reject
               UI   - Unnumbered Information
               DM   - Disconnected Mode
               SABM - Connect Request
               DISC - Disconnect Request
               UA   - Unnumbered Acknowledge
               FRMR - Frame Reject
               Iab  - Information
               ?ccH - Unknown

               a  = Next expected frame number (0 - 7)
               b  = Frame number of this frame (0 - 7)
               cc = Hexadecimal value


        In addition, one of the following characters will be
        displayed, reflecting the protocol version, command/response
        bits, and the poll/final bit: 

           (blank) = version 1 frame without poll/final bit
                 ! = version 1 frame with poll/final bit
                 ^ = version 2 command frame without poll bit
                 + = version 2 command frame with poll bit
                 - = version 2 response frame with final bit
                 v = version 2 response frame without final bit

          The protocol identifier field is displayed in hexadecimal

        An unattended mode, controlled by the 'U' command, provides
        for sending user supplied text to a connecting station, and
        then allows that station to leave a brief message.  This mode
        can operate on all channels simultaneously, but in no way
        limits the operator's ability to interact with one of the
        connected channels or the ability to make outgoing connect
        requests. 

        When unattended mode is enabled, link status messages are
        queued to the associated channel and not output to the
        terminal unless that channel is currently selected.  Link
        status messages will therefore be displayed in chronological
        order with the information from that channel. 

        In addition, text supplied by the user with the 'U' command
        will be sent to any station that connects.  If channel 0 is
        left selected, stations may then connect and leave messages
        on channels 1 - 4 (limited by the 'Y' parameter, of course).
        The 'L' command may be used to determine if messages have
        been left on any channel.  Selecting a channel containing
        messages will cause all link status and information from that
        channel to be displayed.  If xon/xoff handshaking is enabled,
        CONTROL-S and CONTROL-Q may be used to regulate the output to
        the terminal to allow comfortable reading. 


        Command Summary
        ~~~~~~~~~~~~~~~

        (In terminal mode all commands are preceded by ESC character)

          COMMAND      PARAMETER      DESCRIPTION
          -------      ---------      -----------

            A (1)          0          Auto linefeed disabled
                           1          Auto linefeed enabled

          * C      Cs1 [Cs2 ... Cs9]  Connect path (0=unproto path)

          * D                         Disconnect

            E (1)          0          Echo input disabled
                           1          Echo input enabled

          * I              Cs         Tnc source callsign

            JHOST (0)      0          Terminal mode enabled
                           1          Host mode enabled

            K (0)          0          Timestamp disabled
                           1          Timestamp status messages
                           2          Timestamp monitoring & status   

            L            [0-n]        Display channel status

            M (IU)      NIUSC+-       Monitor mode

            S (0)         0-n         Select channel (0=unproto)

            U (0)   0    [text]       Unattended mode disabled
                    1    [text]       Unattended mode enabled

            V (0)                     Displays the software version

            Y (4)         0-n         Maximum incoming connections

            Z (3)          0          Flow disabled, xon/off disabled
                           1          Flow enabled, xon/off disabled
                           2          Flow disabled, xon/off enabled
                           3          Flow enabled, xon/off enabled

    
         (0) Default values are shown in parentheses
          n  Number of channels, as specified by CHANNELS keyword
          *  These commands are applicable to each connection channel


        Command Description
        ~~~~~~~~~~~~~~~~~~~

        The 'A' (AutoLF) command is used to enable or disable the
        automatic insertion of LINEFEED characters after CARRIAGE
        RETURN characters to the terminal. 

        The 'C' (Connect) command is used on channels other than 0 to
        initiate a link connection.  A 'C' command issued when channel
        0 is selected sets the unproto path.  If digipeaters are
        specified, 'v' or 'via' is not required (but is allowed)
        between the destination callsign and the digipeater callsigns,
        and callsigns must be seperated by spaces.  Note that on
        channels > 0 this command ignores the destination path and
        only allows connect to the node.  The default unproto address
        for channel 0 is "CQ". 

        The 'D' (Disconnect) command is used to initiate a link
        disconnection. If there is unsent or unacknowledged
        information remaining, the disconnect request frame will not
        be sent until all information has been transmitted and
        acknowledged. No additional information will be received after
        the 'D' command has been issued.  A second 'D' command may be
        entered to force the transmission of the disconnect request
        frame before all information has been sent and acknowledged.
        A 'D' command issued during the establishment of a link or
        after a disconnect request frame has been transmitted will
        cause an immediate return to the disconnected state. 

        The 'E' (Echo) command is used to enable or disable the
        echoing of input (commands and information) to the terminal. 

        The 'I' (Ident) command is used to set and display the TNC
        source callsign.  The initial value is the APPLCALL. If no
        APPLblock was defined, the initial value is all blanks.
        Changing the TNC source callsign on a connected channel is not
        permitted.  If the TNC source callsign is left blank, the TNC
        will not allow connect commands or unproto transmissions.  The
        callsign stored in channel 0 is used to initialize each
        connection channel upon power up or disconnection. 

        The 'JHOST' command is used to switch between terminal and
        host modes.  See the DEDHOST MAN page for details of host
        mode operation. 

        The 'K' command controls the time stamping of status messages
        and monitored frames. 

        The 'L' (LinkStatus) command is used to display the link
        status of one or all channels.  Information displayed
        includes the connection path and the number of received frames
        not yet displayed, number of send frames not yet transmitted,
        number of transmitted frames not yet acknowledged, and the
        current retry count.  A '+' character preceeding the channel
        number indicates the currently selected channel.  Operation of
        this command when host mode is enabled is somewhat different,
        and is described in the MAN page for DEDHOST. 

        The 'M' (Monitor) command is used to set the frame monitoring
        mode.  The command parameter determines the types of frames
        monitored, and is a list of desired frames chosen from the
        letters in the following table: 

               LTR       FRAME
               ---       -----
                N        None
                I        I frames
                U        UI frames
                S        Supervisory frames
                C        Monitor while connected
                +        Call signs to be included (maximum of 8)
                -        Call signs to be excluded (maximum of 8)

               The '+' and '-' parameters may not be used together.
               If either is used, it must be the last parameter
               (followed by one to eight callsigns, if applicable).
               If no list of callsigns is specified to be included or
               excluded, all callsigns will be candidates for
               monitoring.  Entering a '+' or '-' with no callsigns
               will clear the list. 

        The 'U' (Unattended) command is used to enable or disable
        unattended modes. 

        The 'V' (Version) command just displays the software version.
        In this respect it behaves like TheFirmware instead of WA8DED. 

        The 'Y' command is used to set the maximum number of
        connections that may established by incoming requests.  This
        command has no effect on the operators ability to initiate
        outgoing connection requests. 

        The 'Z' command is used to enable or disable flow control and
        XON/XOFF handshaking to the terminal.  If flow control is
        enabled, output to the terminal will be inhibited while
        entering commands or information.  If flow control is
        disabled, output to the terminal will not be restricted.
        Flow control and xon/xoff handshaking should be disabled
        during periods in which the TNC is operated without a
        terminal, to avoid suspending output which will consume
        buffers.  If XON/XOFF handshaking is enabled, terminal
        scrolling may be stopped and started using CONTROL-S and
        CONTROL-Q characters.  Flow control and XON/XOFF handshaking
        are not performed when host mode is enabled.

        The '@' command is a software maintenance command.  A
        parameter of 'B' displays the number of free buffers. 
    
SEE ALSO
        DEDHOST(9)     -- WA8DED Hostmode Emulation.
        XROUTER.CFG(8) -- Main Configuration File.

WA8DED(9)                   END OF DOCUMENT
