WAIT(1)                XROUTER REFERENCE MANUAL               6/9/2023

COMMAND
        WAIT -- Pause Execution.

SYNOPSIS
        WA[it] <(secs<60) | (ms>60)>

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The WAIT command is intended for use only in BOOTCMDS.SYS.

        It causes execution to pause for the specified time. This
        can be used between commands that need time to execute, such
        as the setting up of tunnel interfaces.

        If the argument to WAIT is less than 60, it is treated as
        SECONDS, otherwise it is treated as milliseconds.

        The following example shows 300ms pauses betwen Linux shell
        commands when setting up a tunnel interface. The sequence
        does not work if the pauses are removed.

        # BOOTCMDS.SYS
        #
        # For setting up tunnels:
        # Assign the address 192.168.0.98 to the Linux end of tun99:
        shell ip address add 192.168.0.98 dev tun99
        #
        wait 300
        #
        # Tell Linux that 192.168.0.99 is on the other end of tun99:
        shell ifconfig tun99 dstaddr 192.168.0.99
        #
        wait 300
        #
        # Bring up the Linux end of the interface:
        shell ip link set dev tun99 up

SEE ALSO
        SHELL(1)        -- Run commands/programs in a Linux 'shell'
        BOOTCMDS.SYS(8) -- Commands to Execute at Bootup

WAIT(1)                  END OF DOCUMENT
