WALL(1)                XROUTER REFERENCE MANUAL               7/12/2023

COMMAND
        WALL -- Access Message Wall(s)

SYNOPSIS
        W[all] [nodecall | nodealias] 

AVAILABILITY
        All users.

DESCRIPTION
        The WALL command connects the user either to this node's
        message "wall", or to the wall on another XRouter. 

        The "wall" is a public message board / guestbook where users
        can leave short text messages, comments, suggestions,
        reminders, observations etc.  Think of it as a text-only
        version of the old Facebook wall.

        Unlike a BBS, wall messages are not forwarded to other systems,
        and they do not expire. They have no "to" or "subject" fields,
        they are just a string of text, like a tweet.

        The wall may also be operated via the sysop's web interface,
        via MQTT, and via REST.

        The WALLFLAGS directive enables or disables the wall, and
        controls whether the sysop is notified (via the PMS) of new
        posts. It also controls whether postss and replies are
        published to the MQTT broker.

OPTIONS
        If no argument is supplied to the WALL commmand, the user is
        connected to the local wall.

        If the argument is the nodecall or alias of another XRouter,
        which is in the nodes table, the user is connected to the
        wall of that node instead.

        After the WALL command is issued, the user is shown the most
        recent 5 messages in reverse chronological order, plus a menu
        with the following options:

        H[elp]   Displays this help.

        L[ist]   Displays or re-displays up to 5 messages at a time.
                 Messages are displayed in reverse chronological order,
                 i.e. the most recent at the top.

        O[lder]  Displays up to 5 older messages, i.e. back in time.

        N[ewer]  Displays up to 5 newer messages, i.e. forward in time.

        W[rite]  Begins message entry. Messages can be up to 255
                 characters, and are posted upon receipt of a <CR>
                 (carriage return).

        D[elete] Deletes a message that the user has just entered.
                 The user cannot delete other people's posts. Only the
                 sysop can do that.

        Q[uit]   Returns the user to the node.

EXAMPLES
        WALL       -- Connect to the wall on this node
        WALL G8PZT -- Connect to the wall on G8PZT node.

SEE ALSO
        BLOG(1)      -- Access Sysop's Blog.
        MQTT-WALL(9) -- MQTT Interface to Message Wall.
        PMS(1)       -- Personal Message System.
        WALLFLAGS(7) -- Options For Message Wall.

WALL(1)                      END OF DOCUMENT
