;***********************|****|* Max Width *|***|*********************|
WARNCOLOR(7)          XROUTER REFERENCE MANUAL              26/10/2023

NAME
        WARNCOLOR -- Colour For Warnings and Errors.

SYNOPSIS
        WARNCOLOR=<colour>

DESCRIPTION
        WARNCOLOR is an optional directive that can be used both
        in the "global" section of XROUTER.CFG, and within CONSOLE
        definition blocks.

        It specifies the colour used by XRouter for warning and
        error messages, such as "Invalid port", "Syntax error",
        "System busy", and so on.

        If used in the "global" section of XROUTER.CFG, the setting
        is inherited by all CONSOLEs subsequently defined.

        If used within a CONSOLE definition block, it applies only
        to that console, overriding any inherited setting.

        The default WARNCOLOR is CERISE.  Default colours have
        been carefully chosen for good visibility against a BLACK
        background.

OPTIONS
        <colour> should be one of the 16 colour names described in
        COLOURS(6), but please note that some colour combinations
        have very poor visibility.

        In general, the lighter the background colour, the smaller
        the choice of foreground colours that will work with it.

EXAMPLE
        WARNCOLOR=PINK

SEE ALSO
        ANSI(1)         -- Enquire/set ANSI colour mode
        COLOURS(6)      -- XRouter Display Colours.
        CONSOLES(6)     -- About XRouter Consoles.
        ACTIONCOLOR(7)  -- Colour For XRouter Actions and Events.
        CAPTIONCOLOR(7) -- Colour For Captions and Headings.
        PROMPTCOLOR(7)  -- Colour For XRouter Prompts.
        XROUTER.CFG(8)  -- Main Configuration File.

WARNCOLOR(7)                 END OF DOCUMENT
