;***********************|****** Max Width *****|*********************|
WPAGES(9)               XROUTER REFERENCE MANUAL             29/3/2024

COMMAND
        WPAGES -- White Pages Database.

DESCRIPTION
        The WP (White Pages) database on this mailbox is part of a
        world wide distributed database, which holds details of all
        recently active Packet users. The database is primarily used
        by mailboxes to make mail routing decisions. The data is
        also available to users via a number of search commands.

        The data is collected from two main sources:

           a) from the details a user enters when they register on a
              mailbox.
           b) from the headers of mail in transit.

        There are 3 classes of data as follows:

            /U    User-entered, via one or more of the "N" commands.
                  This is the most reliable date.

            /I    "Is-BBS", generated by each BBS for its own
                  callsign, and inferred from routing headers, when
                  the user call and BBS call are the same.

            /G    "Guessed" or "Gleaned" from routing headers, when
                  the user call and BBS call are different. Not to
                  be trusted, because users often send mail from
                  BBS's that are not their "Home" BBS.

        WP data is stored in memory, mirrored in the file WP.DAT,
        which is located in the PMS folder. This is a plain text
        file, so it can be edited with any text editor if necessary.
        The file is read only at boot-up, and is written whenever
        there are any changes.

        Most mailboxes with WP capability share their data by means
        of regular "WP Update" messages.  These were supposed to be
        sent to "regional" servers, which would collate the data and
        send it via regional and national servers to a world server.

        That system has fallen apart over time. The current advice
        is to send WP updates as private messages to your immediate
        neighbours only. This can be set up using one or more
        "WpUpdateTo" directives in PMS.CFG.

        XRouter only shares "/U" (user-entered) data via WP updates.

        If a user has not sent a message, and has not re-registered
        on a BBS within a certain period, their details are purged
        from the WP database. That period is commonly 90 days, but
        can be as little as 30 days. XRouter currently does not
        expire WP entries.

        There are many packet users who NEVER log into a mailbox,
        and who are therefore "invisible" to WP.

        The local database can be searched using the I, I@, IC, IH,
        IN, IQ and IZ commands, which each have their own MAN pages.

SEE ALSO
        INFO(4) -- Display Mailbox or White Pages Information.
        PMS.CFG(8) -- PMS Configuration File.

WPAGES(9)                   END OF DOCUMENT
