WX-SVC(9)               XROUTER REFERENCE MANUAL               7/9/2023

NAME
        WX-SVC -- NetRomX Weather Service

DESCRIPTION
        The weather service returns local weather information, if
        available. It is accessed via NetromX service number 16.

        The information is returned in machine-readable plain text
        form. A typical response would look like this:

        Observed: Mon 17 May 2021 06:01:23 +0001
        Pressure: 1007.2 mB
        Temperature: 11.2 C
        Humidity: 67 %
        Wind: 23 mph
        Direction: 178 deg
        Gust: 31 mph
        Rain-24h: 24.7 mm
        Rain-Today: 19.7 mm
        Rain-1h: 3.2 mm

        When the client has recieved the information, the server
        terminates the connection.

        Some fields may be missing if there is no information in them.

        The information is derived from received APRS broadcasts, or
        from the WXNOW or CUMULUS format files generated by home
        weather stations or weather applications. The filename is
        specifed by the WXFILE directive in XROUTER.CFG.

        Once per minute, XRouter checks the file specified by the
        WXFILE directive. If the file is present, and the information
        therein is more up to date than the previous data, the
        contents of the file are imported.

        A WXNOW.TXT file only has 2 lines, for example:

        Feb 01 2009 12:34
        272/010g006t069r010p030P020h61b1050

        where:  272   = Wind direction in degrees.
                010   = Average wind speed in MPH.
                g006  = Gust speed in MPH
                t069  = Temperature in degrees Farenheit
                r010  = Rainfall in last hour in 0.01 inch.
                p030  = Rainfall in last 24H in 0.01 inch.
                P020  = Rainfall since midnight in 0.01 inch.
                h61   = Humidity in percent.
                b1050 = barometric pressure in millibars.


        The Cumulus "realtime.txt" file is a text file with a single
        line of space separated values. It contains a list of key
        values of the sensors and is re-created frequently. After
        creation, it can be set to automatically upload to a website
        (or to XRouter) via FTP.

        An example of the format is as follows (all one line):

        18/10/08 16:03:45 8.4 84 5.8 24.2 33.0 261 0.0 1.0 999.7 W 6
        mph C mb mm 146.6 +0.1 85.2 588.4 11.6 20.3 57 3.6 -0.7 10.9
        12:00 7.8 14:41 37.4 14:38 44.0 14:28 999.8 16:01 998.4 12:06
        1.8.2 448 36.0 10.3 10.5 13 0.2 14 260 2.3 3 1 1 NNW 2040 ft
        12.3 11.1 420.1 1 13.6

        XRouter currently parses the following fields from
        realtime.txt:

           1    Observation date
           2    Observation time
           3    Temperature
           4    Humidity
           6    Wind speed
           8    Wind direction
           9    Rain rate per hour
           10   Rain today
           11   Barometric pressure
           14   Wind units - m/s, mph, km/h, kts
           15   Temperature units - degree C, degree F
           16   Pressure units - mb, hPa, in
           17   Rainfall units - mm, in
           41   Gust speed
           48   Rainfall last hour


        There is another (non-standard) format that XRouter can import
        from a WX file. This consists of "<name>: <value>" pairs as
        follows:

           Temperature: 22.7
           Barometer: 1015
           Wind: 6
           Direction: 178
           Gust: 12
           Humidity: 67
        
        The fields can be in any order, and need not all be present.
        They may be seperated by spaces or tabs.

        At present, temperature must be in Centigrade, pressure in
        millibars, and wind speeds in MPH. There are plans to make
        this accept other units. 

        If you don't have a weather station that outputs one of the
        above formats, by using suitable software or scripts you could
        extract weather information from your WX station and write it
        to a file in one of the above 3 formats.

        For example, you could use a cheap RTL dongle and "rtl_433"
        software on the Pi to receive and decode the 433.9 MHz OOK
        transmissions from your weather station to its base unit.

        You could even pull weather information for your area off the
        web and write it to a file. But that is beyond the scope of
        this document.

SEE ALSO
        WX(1)       -- Display Weather Information.
        WXFILE(7)   -- Specify Weather Import File.
        SERVICES(9) -- NetRomX Standard Services.

WX-SVC(9)                   END OF DOCUMENT
