;***********************|****|* Max Width *|***|*********************|
WX(9)                   XROUTER REFERENCE MANUAL             28/2/2024

NAME
        WX(9) -- Weather Information System.

INTRODUCTION
        XRouter can gather and store weather information from a local
        weather source and/or from the APRS weather broadcasts of up
        to 5 neighbour nodes. It can display
        the information in response to the WX and INFO commands.

        It can also display the information via its HTTP interface,
        the NetRomX weather server, the integral MQTT server, and
        can broadcast it in APRS-style beacons.

- How it is accessed & presented
- How to set it up
- Wacky ideas

DATA SOURCES

        - APRS Weather broadcasts from nearby nodes.
        - Files deposited by external WX programs e.g. Cumulus
        - MQTT messages addressed to the nodecall.

DATA STORED

        For non-local sources, e.g. APRS broadcasts, the following
        basic information is stored, if the source provides it:

	    - Observation date/time
            - Callsign of the originating source
            - Latitude and longitiude of the observation
            - Distance of the observation from XRouter
            - Barometric pressure
            - Air temperature
            - Humidity
            - Wind direction
            - Wind speed
            - Wind gust speed
	    - Rainfall in last 24 hours
            - Rainfall in the last hour
            - Rainfall since midnight

        For local sources, e.g. import files or MQTT messages, the
        following additional data is stored, if the source provides
        it:

            - Sensor battery state
            - Light level
            - UV level

        If the source provides the required data, the following
        "derived" values may also be stored:

            - Today's pressure max/min and the times thereof.
            - Today's average pressure.
            - Today's temperature max.min and the times thereof.
            - Today's average temperature
            - Tofay's humidity max/min and the times thereof
            - Today's average humidity.
            - Today's maximum wind and gust speeds and times thereof
            - Running average wind direction (last 11 readings)
            - Running average wind speed
            - Current rainfall rate
            - Today's maximum rainfall rate and time threof
            - Temperature trend.
            - Dew Point
            - Wind Chill
            - Heat Index
            - Wind Run

STORAGE UNITS / PRECISION

        Parameter     Stored as        Precision
        --------------------------------------------
        Lat/long        Degrees        0.01 minutes
        Date/time       Seconds        1 sec
        Pressure        Millibars      0.1 mb
        Temperature     Degrees C      0.1 C
        Humidity        Percent        1 percent
        Wind speed      Miles Per Hour 0.1 mph
        Wind direction  Degrees        1 degree
        Rainfall        Millimetres    0.1 mm
        Wind Run        Miles          0.001 mile
        Max/Min times   Hour:minute    1 minute
        Dew point       Degrees C      0.1 C
        Wind Chill      Degrees C      0.1 C
        Heat Index      Degrees C      0.1 C

STORAGE ACROSS REBOOTS

        The WXSAV.DAT file preserves most data across reboots, but
        for the first few observations after a reboot there will be
        no trend or running average information. That will appear
        after a few observations.

DATA ACCESS

        COMMAND LINE
            The WX command is used to display a list of available WX
            datasets, to display the data from a specified source,
            or to obtain a WX summary from another XRouter. See the
            WX(1) man page for details.

            The page displayed by the INFO PAGE command contains a
            brief local weather summary comprising date, time, air 
            pressure, temperature, humidity, wind speed, gust speed,
            and wind direction, if such information is available.

        WEB PAGE
            If XRouter's HTTP server is enabled, and local weather is
            available, it is displayed on the following page:
            http://{ipaddress[:port]}/localwx
            where ipaddress and port are those of XRouter

        WX SERVER
            XRouter's "weather summary server", accessed via NetromX
            service number 16, returns local weather information, if
            available. The information is returned in a machine and
            human readable plain text form. See the WX-SVC(9) manual
            page for more details.

        MQTT BROKER
            XRouter's integral MQTT broker makes weather information
            available, both as "events" and upon request. The former
            are published whenever new data arrives, and the latter
            are published upon request. The broker may be accessed
            either via MQTTPORT on the LAN and/or amprnet, or via a
            NetromX connection to service 1883. The inbuilt MQTT
            client can be used to make such a connection, as can any
            other client of your choosing.

            To receive WX "events", subscribe to the following topic:

                xrouter/event/{nodecall}/wx/{callsign | #}

            To request WX information, first subscribe to

                xrouter/status/{nodecall}/wx[callsign]

            then PUBlish xrouter/get/{nodecall}/wx[/callsign]

        APRS BROADCASTS
            XRouter can be configured to broadcast APRS-format WX
            beacons at specified intervals on specified PORTs.







MQTT/Json
~~~~~~~~~
Some weather stations supply rainfall in total bucket tips, e.g. "Rainfall":1186, others as total mm, e.g. "rain_mm" : 467.106.


If "mm" is not prsent

{"time" : "2024-03-04 18:58:15", "model" : "Fineoffset-WH65B", "id" : 80, "battery_ok" : 1, "temperature_C" : 6.200, "humidity" : 89, "wind_dir_deg" : 204, "wind_avg_m_s" : 0.000, "wind_max_m_s" : 0.000, "rain_mm" : 514.096, "uv" : 0, "uvi" : 0, "light_lux" : 0.000, "mic" : "CRC"}

There doesn't seem to be any standard for the field names. For instance the observation timestamp could be sent as "timestamp" or "observed" instead of "time". Temperature could be sent as "temp", temperature_deg_c, "temperature_C" and so on.

        Xrouter can be customised to recognise the field names used in
        the data source, using a set of optional directives in
        XROUTER.CFG as follows:

          Name       Default          Purpose
	  --------------------------------------------------------
          WXBATTERY  "battery_ok"     Sensor battery indication
          WXBEARING  "wind_deg"       Wind direction in degrees
          WXGUST     "wind_max_m_s"   Gust speed in metres per sec
          WXHUMID    "humidity"       Relative humidity in pecent
          WXID       "id"             Sensor number
          WXLIGHT    "light_lux"      Solar Irradiance in lux
          WXMODEL    "model"          Sensor make/model
          WXPRESS    "pressure"       Air pressure in millibars
          WXRAIN     "rain_mm"        Total rainfall in mm
          WXSPEED    "wind_speed_m_s" Wind speed in metres per sec
          WXTEMP     "temperature_c"  Air temperature in degress C
          WXUV       "uv"             UV level
          WXUVINDEX  "uvi"            UV Index

RELATED DIRECTIVES

        WXSENSOR    A string of characters (max 31) which identifies
                    the desired weather sensor in the source data
                    stream, e.g. "Fineoffset-WH65B".
                    For use where the data source might contain data
                    from more than one weather sensor, or from other
                    types of sensor that may share the same parameter
                    names, e.g. tyre pressure sensors. There is no
                    default. If specified, only data whose "model"
                    field contains the specified string is accepted.

        WXSENSORID  A string of characters (max 15) which uniquely
                    identifies a particular sensor among sensors of
                    the same make/model. e.g. "80".
                    Can be used in conjunction with WXSENSOR, or on
                    its own. There is no default. If specified, only
                    data whose "id" field contains the specified
                    string is accepted.

        WXBUCKET    Specifies the "bucket size" in mm for a bucket
                    tipping pluviometer. This is the amount of rain
                    required to increment the "rainfall" count by one
                    unit.
                    Bucket sizes typically range from 0.1 to 1mm,
                    with 0.3mm and 0.254mm being common sizes for
                    amateur weather stations. Defaults to 0.3

        WXWINDGAIN  A correction factor which can be applied to the
                    wind speed input to compensate for non-ideal
                    siting of the anemometer. Default is 1.0.
                    The "standard height" for wind speed measurements
                    is 10 metres above unobstructed ground. Due to
                    air resistance and obstructions, wind speed
                    reduces at lower heights. If the wind speed at 4m
                    above ground was half the level at 10 metres, a
                    WXWINDGAIN of 2 would cause the "correct" wind
                    speed to be displayed. However, the meaning of
                    "correct" wind speed is debateable -  if a 
                    greenhouse in a sheltered garden can withstand a
                    wind speed of 49mph before collapsing, it is the
                    ground level wind speed that's important, not
                    the 10m AGL speed.
                    WXWINDGAIN can also be used to adjust







Directives:
~~~~~~~~~~~
WXMODEL - optional. For use where . The field name defaults to "model" is specified by

WXBATTERY:
Optional. Defaults to "battery_ok"

WXBEARING:
Optional. Defaults to "direction"






WXFILE:
Specifies the pathname of a file from which XRouter can read weather data. There is no default. If WXFILE is specified, and the file exists, XRouter reads its contents once per minute. The contents of the file may be in Cumulus WXNOW.TXT or REALTIME.TXT formats, which are well documented on the web.

(list the name value pairs expected here)

"Temperature:" Degrees centrigrade
"Barometer:" 	Pressure (millibars)
"Wind:"		speed in MPH;
"Direction:"	Degrees;
"Gust:"		speed in MPH
"Humidity:" 	0-100 (percent)


WXGUST:
Specifies the field name used for reading the wind gust speed from a JSON message or weather file. Max 15 characters. Defaults to "gust"

WXHUMID:
Specifies the field name used for reading the humidity (in percent) from a JSON message or weather file. Max 15 characters. Defaults to "humidity".

WXID:
			pztncpy (WxId, args, 15);
			break;

		case CMD_WXLIGHT:
			pztncpy (WxLight, args, 15);
			break;

		case CMD_WXMODEL:
			pztncpy (WxModel, args, 15);
			break;

		case CMD_WXPRESS:
			pztncpy (WxPress, args, 15);
			break;

		case CMD_WXRAIN:
			pztncpy (WxRain, args, 15);
			break;

		case CMD_WXRAINTYPE:
			break;

		case CMD_WXSENSOR:
			pztncpy (WxSensor, args, 31);
			break;

		case CMD_WXSENSORID:
			pztncpy (WxSensorId, args, 15);
			break;

		case CMD_WXSPEED:
			pztncpy (WxSpeed, args, 15);
			break;

		case CMD_WXTEMP:
			pztncpy (WxTemp, args, 15);
			break;

		case CMD_WXTIME:
			pztncpy (WxTime, args, 15);
			break;

		case CMD_WXWINDGAIN:
			WxWindFactor = atof (args);

WXUVINDEX:
Specifies the JSON field name used for reading the UV index. Defaults to "uvi".


OPTIONS

UPDATING VIA HTTP

If you have a weather station that can be configured to upload to a custom server using Wunderground PWS protocol, it can upload directly to XRouter.

Configure the weather station as follows:

a) choose "Upload to custom server"
b) choose Wunderground protocol
c) Set the "Server IP/Hostname:" field to Xrouter's IP
d) Set "Path:" to /wx/report?
e) Set "station ID:" to a string of your choice, e.g. KidderWX
f) Set "Station Key:" to a suitable password of your choice
g) Set "Port:" to whatever your HTTPPORT is set to
h) Set "Upload Interval" to your choice
i) Save

Configure XRouter as follows



# Updates sent as GET requests to /wx/report
# Uses Wunderground PWS upload protocol
# PWS station ID
WXSENSORID=Fal

# Password
WXCMD=12345

;# Multiplier to compensate for lack of anemometer height AGL
WXWINDGAIN=2.0


API (see REST-WX.9.MAN) and possibly MQTT

        a) Retrieve List of Weather Stations:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  /api/v1/weather/stations

        If successful, the response is an un-named JSON array of
        objects, each object containing the following fields:







It is strongly recommended that you use WXSENSOR to avoid reading erroneos data from other type of device.
        

SEE ALSO
        WX(1) -- Display Weather Information.
        WXID.7
        WXLIGHT.7
        WXMODEL.7
        WXPRESS.7
        WXRAIN.7
        WXRAINTYPE.7
        WXSENSOR.7
        WXSENSORID.7
        WXSPEED.7
        WXTEMP.7
        WXTIME.7
        WXWINDGAIN.7
        WXUV.7
        WX-SVC(9)      -- NetRomX Weather Service
        XROUTER.CFG(8) -- Main Configuration File.
        

WX(9)                        END OF DOCUMENT
;***********************|****|* Max Width *|***|*********************|