WX(1)                  XROUTER REFERENCE MANUAL               6/9/2023

COMMAND
        WX -- Display Weather Information.

SYNOPSIS
        WX [callsign | LOCAL]

AVAILABILITY
        All users

DESCRIPTION
        The WX command is used to display a list of up to 5 local
        APRS weather stations, and to display a weather summary from
        specified stations.

        The information displayed includes: date and time of reading,
        distance and direction of server, pressure, wind speed and
        direction, gust speed, temperature, humidity, and rainfall.

OPTIONS
        If no argument is supplied, the callsigns of the available
        weather stations (if any) are displayed.

        If the argument is the callsign of one of the stations in the
        list, the weather summary from that station will be displayed.

        However, if [callsign] is not in the list of stations
        returned by WX", and it matches the callsign or alias of an
        XRouter in the nodes table, a connection to that node's
        weather service is attempted. If successful, the weather
        information is returned, like this:

        wx g8pzt
        G8PZT-1:MOBILE} Trying G8PZT::16...
        G8PZT-1:MOBILE} Connected to G8PZT::16

        Observed: Mon 17 May 2021 06:01:23 +0001
        Pressure: 1007.2 mB
        Temperature: 11.2 C
        Humidity: 67 %
        Wind: 23 mph
        Direction: 178 deg
        Gust: 31 mph
        Rain-24h: 24.7 mm
        Rain-Today: 19.7 mm
        Rain-1h: 3.2 mm

        G8PZT-1:MOBILE} Welcome back

        The special case "WX LOCAL" returns the local WX information,
        if available.

EXAMPLE
        WX           - Display local APRS weather stations
        WX G6GUH-3   - Display weather summary from station G6GUH-3

LIMITATIONS
        The collection of weather data requires at least one APRS RF
        port, plus a weather station within range. Failing that,
        weather data will be collected if the IGATE daemon is running
        and connected to a suitable APRS server.  Alternatively it
        can be imported every minute from a file.

SEE ALSO
        WX-SVC(9) -- NetRomX Weather Service

WX(1)                      END OF DOCUMENT
