XRNODES(8)              XROUTER REFERENCE MANUAL            19/10/2023

NAME
        XRNODES -- Routes / Nodes Recovery File.

DESCRIPTION
        The XRNODES file contains a list of the known NetRom
        routes and nodes, and is used to populate the nodes table
        when XRouter boots.  This allows XRouter to be stopped and
        restarted without losing the nodes table. Without this
        file, it would take several hours to rebuild the nodes
        table from received broadcasts.

        The nodes and routes tables are saved to this file every 
        NODESINTERVAL, at close-down, and whenever the SAVENODES
        command is used (unless a different filename is specified).

        The file is created by XRouter, but may be edited by the
        sysop. Apart from the lack of .TXT extension, it is an
        ordinary plain text file.

FORMAT
        The ROUTE entries are specified first, and have the
        following format:

        ROUTE ADD <call> <port> <qual> [!] [VIA call ...] [options]

        <call> is the callsign of the neighbour node.

        <port> is the port on which the neighbour is reached.

        <qual> is a "quality" between 0 and 255 indicating how
               "good" the route is.

        [!] indicates a locked route (i.e. one which will not expire).

        [VIA] indicates that the neighbour is reached via
              digipeater(s). Digipeater callsigns are separated by
              exactly ONE space, with the end of the list marked by
              exactly TWO spaces.

        [options] are "non-standard" parameters which can override
                  the port defaults for that route as follows:

           [maxframe [frack [paclen [maxtt [maxhops]]]]]

        For example:

            ROUTE ADD W7XCV 1 100
            ROUTE ADD G8UYL 2 240 ! 5 7000 120
            ROUTE ADD G7DIG 5 ! VIA M7FRT M3RED  2 

            The first line shows unlocked neighbour W7XCV on port 1
            with quality of 100.  The second line shows neighbour
            G8UYL locked in on port 2 with a quality of 240,
            maxframe of 3, frack of 7000, and paclen 120.  The
            third line shows neighbour G7DIG locked in using a
            digipeated path via M7FRT and M3RED, with maxframe of 2.


        Following the ROUTE entries, the remainder of the file
        consists of NODE entries, one per line. The format is as
        follows:

        NODE ADD <alias:call> <r1> <p1> <q1> [!] [<r2> ...]

        <alias:call> is the alias and callsign of the distant node.
 
        <r1> is the callsign of the primary route to that node,
                 for which there must exist a ROUTE entry.

        <p1> is the port used to reach the neighbour.

        <q1> is the quality of the route to the node via that
                neighbour.

        [!] indicates a locked entry.

        There can be up to 3 different routes listed for each node.
        For example:

            NODE ADD #TLFRD:GB7IPT-7 G8PZT 1 142 ! G8UYL 2 139
            NODE ADD BRUM:GB7BM G8PZT 1 94 G8UYL 2 92
            NODE ADD BUXTON:GB7DAD-8 G8PZT 1 22 G8UYL 2 21

FILES
        XRNODES is located in the same directory as XRouter.

CAVEATS
        If XRouter is closed down for more than a few hours, the
        network may change, and the XRNODES file will become out
        of date. This could re-introduce expired nodes back into
        the tables when XRouter is started. In this case it would be
        better to delete XRNODES before booting up, and let XRouter
        rebuild the tables from broadcasts.

SEE ALSO
        LOADNODES(1) -- Load the nodes and routes tables.
        SAVENODES(1) -- Save the nodes and routes tables.

XRNODES(8)                  END OF DOCUMENT
