XROUTER.CFG(8)          XROUTER REFERENCE MANUAL            19/10/2023

NAME
        XROUTER.CFG -- Main Configuration File (Mandatory).

DESCRIPTION
        This file is mandatory, and contains most of the
        configuration info for XRouter.  It is read only when the
        program starts.

        It is a text file containing directives of the general form
        <keyword>=<value>, each on a separate line.  Keywords are
        not case sensitive, and in general they may be specified
        in any order, but interfaces MUST be defined before the
        ports that reference them.
  
        Blank lines are allowed, and comment lines must begin with
        a semicolon (;) or hash (#) in the leftmost column.  Lines
        must not exceed 255 characters.

        The sections of the file outside the INTERFACE, PORT, RADIO,
        CONSOLE, APPL and ROUTES blocks, are considered "global",
        i.e. this is where the keywords with global action can be
        used. E.g. this is where the node callsign and alias are
        specified.

        Some of the keywords, e.g. IPADDRESS and PACLEN may be
        used globally (to set defaults) and within PORT definition
        blocks (to set port-specific overrides).
       
        In the following sections, '*' indicates the mandatory
        parameters. Additional parameters (e.g. IPADDRESS) may need
        to be specified to enable full operation. Remaining
        parameters have sensible defaults built into the program.
        Defaults are indicated in brackets ().

GLOBAL KEYWORDS
        The following keywords are accepted in the GLOBAL section:

        ACTIONCOLOR    Text colour for pending actions (yellow)
        AGWPORT        TCP port for AGWPE emulator (8000)
        ALTITUDE       Site altitude above mean sea level (0)
        APPL           Begins an application definition block
        APPLQUAL       Default NetRom quality for applications (150)
        APRSCALL       Callsign used by Igate
        APRSPORT       TCP port for APRS server (1448)
        AUDIODEVICE    Audio output device name
        BELL           Allowed times for console bells (0800-2200)
        BLEVEL         Netrom Budlist de-rate level.
        BOOTWIN        Window to display after bootup (6)
        CHATALIAS      Chat server alias
        CHATCALL       Chat server callsign
        CHATLINKS      Callsigns of linked chat servers
        CHATLOG        Controls logging of chat server activity (0)
        CHATPORT       TCP port for Chat server (3600)
        CHATQUAL       Chat server Netrom quality to bcast (150)
        COMMAND        Creates a custom command.
        CONSOLE        Begins a CONSOLE definition block.
        CONTACT        Sysop's contact details.
        CTEXT          Text sent to a users upon connection
        CTFLAGS        Flags which control sending of CTEXT (9)
        CTRLADDR       Hex address of hardware control port (378)
        DEFAULTLANG    Default language number (0)
        DCACHE         Size of domain cache (10)
        DISCARDPORT    TCP port for Discard server (9)
        DNS            Domain Name Server to use (internal)
        DOMAIN         Domain suffix (ampr.org.)
        DXFLAGS        Controls the DX heard display (0)
        ECHOPORT       TCP port of Echo server (7)
        ENABLE_LINKED  Controls who may use "*** LINKED AS"
        EXCLUDE        AX25 L2 callsign Blacklist
        FINGERPORT     TCP port of Finger server (79)
        FTPPORT        TCP port for FTP server (21)
        HAAT           Antenna Height Above Average Terrain (0)
        HAMLIBPORT     TCP Port for Hamlib emulation server
        HIDENODES      Controls visibility of '#' nodes (0)
        HOSTNAME       Host name for TCP/IP operations
        HTTPPORT       TCP port for HTTP server (80)
        HTTPROOT       HTTP server's root directory (HTTP)
        IDINTERVAL     Minutes between IDTEXT broadcasts (15)
        IDLETIME       Idle link shutdown time in secs (900)
        IDTEXT         ID beacon sent every IDINTERVAL
        IGATE          Controls whether Igate starts at boot up (0)
        INFOTEXT       Text sent in response to "I" command
        INPBCINTERVAL  Secs between scheduled INP3 unicasts (600)
        INTERFACE    * Begins Interface definition block
        IPADDRESS      Main (amprnet) IP address (0.0.0.0)
        IPENCAP        Enable/disable IPENCAP protcol 4 (0)
        IPIP           Enable/disable IPIP protocol 94 (0)
        IPTTL          IP Time to live (255)
        IPUDPPORT      UDP port for rcving IPUDP traffic (94)
        KILONFWD       Kill PMS message after forwarding (0)
        L3BUDLEVEL     Leakage level (0-255) for L3EXCLUDE (0)
        L3EXCLUDE      Callsigns whose L3 traffic is disrupted
        L3RTTINTERVAL  Secs between L3RTT checks (300)
        L3TTL          NetRom layer 3 Time To Live (25)
        L4DELAY        NetRom layer 4 delay in secs (3)
        L4RETRIES      NetRom layer 4 retries (3)
        L4T3           L4 link check interval in secs (840)
        L4TIMEOUT      NetRom layer 4 timeout in secs (120)
        L4WINDOW       NetRom layer 4 window (10)
        LATITUDE       Latitude in decimal degrees (999)
        LOCATOR        Maidenhead QTH locator (empty)
        LOG            Controls activity logging level (0)
        LONGITUDE      Longitude in decimal degrees (999)
        MAPCOMMENT     Short text to display on nodes map
        MAPSERVADDR    Hostname / IP address of nodes map server
        MAPSERVPORT    TCP port of nodes map server (80)
        MAXARP         Max size of ARP table (20)
        MAXCIRCUITS    Max concurrent NetRom L4 circuits (20)
        MAXHOPS        Max acceptable hop count (30)
        MAXLINKS       Max simultaneous AX25 L2 connections (30)
        MAXNODES       Max size of NetRom nodes table (200)
        MAXROUTES      Max NetRom neighbour routes (30)
        MAXSESSIONS    Max simultaneous sessions (20)
        MAXTCP         Max simultaneous TCP connections (20)
        MAXTT          Maximum Trip Time in secs (500)
        MINQUAL        Minimum NetRom quality in nodes table (10)
        MQTTSERVADDR   Hostname / IP addr of external MQTT broker
        MQTTSERVPORT   TCP port of external MQTT broker (1883)
        NFTPROOT       Root directory for Netrom FTP
        NODEALIAS    * AX25/NetRom alias of this node
        NODECALL     * AX25/NetRom callsign of this node
        NODESINTERVAL  Mins between nodes broadcasts (60)
        NUMCONOLES     Number of consoles (3)
        OBSINIT        NetRom obsolescence initial value (5)
        OBSMIN         NetRom obsolescence min to broadcast (3)
        PACLEN         AX25 default / NetRom packet length (120)
        PMSALIAS       AX25/NetRom alias of integral PMS
        PMSCALL        AX25/NetRom callsign of integral PMS
        PMSHADDR       PMS hierarchical address
        PMSQUAL        PMS NetRom quality to broadcast (0)
        PORT         * Begins a port definition block
        PROMPTCOLOR    Text colour for normal prompts (cyan)
        PROXY          Defines a NetRom proxy
        QUALADJUST     Derates NetRom quality by callsign (255)
        QTH            Location of this node (empty)
        RADIO          Begins a RADIO definition block
        RHPPORT        Remote Host Protocol server TCP port (9000)
        RIGSRVPORT     TCP port for radio server
        RLOGINPORT     TCP port for Rlogin server (513)
        ROUTES         Specifies locked-in NetRom routes
        ROWS           Vertical size of display in rows (25)
        SESSLIMIT      Max sessions per user (10)
        SOCKSPORT      TCP port for SOCKS proxy server (1080)
        SORTBYCALL     Sort nodes table by callsign not alias (0)
        SYNCACHELIFE   Lifetime in seconds of a cached TCP SYN (10)
        SYNCACHESIZE   Number of SYN cache slots (1000)
        T3             AX25 link check timer in secs (180)
        TELNETPORT     TCP port for Telnet server (23)
        TELPROXYPORT   TCP port for Telnet Proxy server (2323)
        TEXTCOLOR      Text colour for normal text (white)
        TTYLINKPORT    TCP port for TTYLINK server (87)
        UIFLOOD        APRS N-n digipeating (WIDE)
        UITRACE        APRS N-n digipeating (TRACE)
        WARNCOLOR      Text colour for warnings & errors (cerise)
        WXFILE         Weather import file name


APPL KEYWORDS
        The following keywords are accepted in the APPL blocks:

        APPLALIAS      Aplication alias
        APPLCALL       Application callsign
        APPLFLAGS      Flags which control application
        APPLNAME       Application name
        APPLQUAL       Application NetRom qulity to broadcast
        APPLTYPE       Type of application (for TCP only)
        ENDAPPL      * Ends application definition block


CONSOLE KEYWORDS
        The following keywords are accepted in CONSOLE blocks:

        ACTIONCOLOR     Text colour for confirming actions (yellow)
        BOTWINBGCOLOR   Background for menu bar (cyan)
        BOTWINTXTCOLOR  Text colour for menu bar (white)
        CAPTIONCOLOR    Text colour for captions (lime)
        CMDWINBGCOLOR   Background color for command line (navy)
        CMDWINTXTCOLOR  Text colour for command line (yellow)
        CONSOLECALL     Callsign for console operations
        CONSOLELANG     Language number for console ops (0=English)
        ECHOCOLOR       Colour for text echoed from cmd line (yellow)
        ENDCONSOLE    * Ends console definition block
        MIDWINBGCOLOR   Background for central window (black)
        MIDWINTXTCOLOR  Text colour for central window (white)
        MMASK           Flags specifying protocols to trace (3f8)
        MPORTS          Ports to monitor by default (all)
        PROMPTCOLOR     Text colour for prompts (cyan)
        REVIEW          No. of lines of scrollback (400)
        RXCOLOR         Text color for RX tracing (lime)
        TOPWINBGCOLOR   Status line background colour (cyan)
        TOPWINTXTCOLOR  Status line text colour (white)
        TXCOLOR         Text colour for TX tracing (pink)
        WARNCOLOR       Text colour for warning/error msgs (cerise)

INTERFACE KEYWORDS
        The following keywords are accepted in INTERFACE blocks:

        APPLNUM         Application number (DEDHOST only)
        CHANNEL         Channel on multi-channel hardware
        CHANNELS        No. of TNC channels (DEDHOST only)
        COM             COM number
        CONFIG          Hardware-specfic coonfig options
        ENDINTERFACE  * Ends interface definition block
        ETHADDR         Ethernet address (NdisXpkt only)
        FLOW            Flow control options (async only)
        ID              Interface identification string
        INTNUM          Was interrupt number, now multi-purpose
        IOADDR          Was I/O address, now multi-purpose
        KISSOPTIONS     Options for KISS interfaces only
        MTU           * Maximum Transmission Unit
        PROTOCOL        Protocol used on this interface
        RADIO           Radio number associated with interface
        SPEED           Serial (async) or RF (SCC) baud rate
        TYPE          * Type of hardware

PORT KEYWORDS
        The following keywords are accepted in PORT blocks:

        APPLMASK        Controls which applications are visible
        APRSPATH        Default digipeater path for APRS
        BCAST           List of destinations for "broadcasting"
        BCFROM          Callsigns who may broadcast
        CFLAGS          Controls AX25 up/downlinking
        CHANNEL         Channel to use on interface (A)
        CHATALIAS       Port override for global chatalias
        CHATCALL        Port override for global chatcall
        CTEXT           Port override for global ctext
        CTFLAGS         Port override for global ctflags
        CWID            Text to send in CW every 30' (SCC only)
        DHCP            Enables / disables DHCP client (0)
        DIGIFLAG        Controls digipeating
        DIGIPORT        Port to digipeat on (this port)
        DYNDNS          Enable / disable Dynamic DNS update client
        ENDPORT       * Ends port definition block
        EXCLUDE         List of callsigns not allowed to connect
        FEC             Enable / disable Forward Error Correction (0)
        FRACK           AX25 Frame Acknowledgement time ms (7000)
        FREQUENCY       Radio frequency in Hz (0)
        FULLDUP         Allow simultaneous TX/RX (SCC only)
        ID            * Text to identify port on ports display
        IDPATH          Dest & digi path for ID beacons ("ID")
        IDTEXT          Port override for global IDTEXT
        INITSTR         Modem initialisation string (modem only)
        INTERFACENUM  * Interface number this port is bound to
        INTERLOCK       Prevents simultaneous TX on SCC cards
        IPADDRESS       Port override for global IP address
        IPLINK          IP address / hostname of AXIP/AXUDP peer
        MAXFRAME        Max outstanding AX25 L2 frames (3)
        MAXHOPS         Port override for global MAXHOPS
        MAXTT           Port override for global MAXTT
        MHEARD          Enable / disable MHeard on this port
        MHFLAGS         Controls contents of MHeard list (255)
        MINQUAL         Port override for global MINQUAL
        MINTXQUAL       Min NetRom quality to broadcast
        NETMASK         Subnet mask used with IPADDRESS
        NODESINTERVAL   Port override for global NODESINTERVAL
        PACLEN          Port override for global PACLEN
        PERSIST         Probability to transmit 0-255 (64)
        PIPE            Creates a "frame pipe" to another port
        PIPEFLAG        Controls frame piping (3)
        PMSALIAS        Port override for global PMSALIAS
        PMSCALL         Port override for global PMSCALL
        PORTALIAS       Port override for global NODEALIAS
        PORTALIAS2      Secondary alias for digipeating only.
        PORTCALL        Port override for global NODECALL
        PROXY           NetRom systems to tunnel AX25 to
        QUALITY         Default NetRom neighbour quality (10)
        RESPTIME        AX25 delayed ack timer in ms (2000)
        RETRIES         Max connect/disconnect/resent attempts (10)
        RFBAUDS         RF baud rate (1200)
        SESSLIMIT       Max simultaneous connections per user (255)
        SLOTTIME        CSMA interval timer (millisecs) (100)
        SOFTDCD         Use software DCD (SCC only) (0)
        SYSOP           If 1, all users on this port are sysops (0)
        TXDELAY         Delay (ms) between PTT and start of data (300)
        TXPORT          Port on which to TX if not this one (0)
        TXTAIL          Delay (ms) between data end and PTT drop (100)
        UDPLOCAL        RX UDP port for AXUDP operations (93)
        UDPREMOTE       TX UDP port / Partners AXUDP RX port (93)
        UNPROTO         Dest & digi calls for unproto broadcasts
        USERS           Max simultaneous users on this port (255)
        VALIDCALLS      Only these callsigns allowed to connect.

RADIO KEYWORDS
        The following keywords are accepted in RADIO blocks:

        BAUDS           Baud rate for the TTY (not for Hamlib).
        COM             TTY device name / IP address:port
        ENDRADIO        End RADIO definition block.
        FREQUENCY       Initial receive frequency in Hz.
        MODE            Initial modulation mode.
        NAME            Name / Description for the radio
        OFFSET          Radio's frequency error in PPM
        PTTMETHOD       How the PTT is controlled
        RXAUDIODEV      Device for receiving audio from radio
        SQUELCH         Initial squuelch level
        STOPBITS        Number of "stop" bits on the serial data
        TXFREQ          Initial TX frequency (if different to RX)
        TYPE            Type number of radio
        VOLUME          Initial volume level

FILES
        XROUTER.CFG must be located in the same directory as the
        XRouter executable.

SEE ALSO
        APPLS(9)  -- Application Support.
        IFACES(6) -- Interfaces in XRouter.
        PORTS(6)  -- PORTS in XRouter.
        RADIO(7)  -- Radio Control Definition Block.

XROUTER.CFG(8)              END OF DOCUMENT
