;***********************|****** Max Width *****|*********************|
YAM(9)                  XROUTER REFERENCE MANUAL             29/9/2023

NAME
        YAM -- "Yet Another Modem" HDLC Modem.

DESCRIPTION
        The "YAM" modem conects to a COM port, and implements the
        functions of a TNC in a FPGA (Field Programmable Gate Array).

        XRouter includes support for the YAM modem, and the interface
        should be defined in XROUTER.CFG as follows:

           INTERFACE=10       <- Adjust to suit
              TYPE=YAM
              COM=1           <- COM port to which YAM is connected
              MTU=256
              SPEED=1200      <- Radio speed (not serial comms speed!)
              PROTOCOL=HDLC   <- Only HDLC supported at present
           ENDINTERFACE

        SPEED is the *radio* baud rate and should match the modem's
        configuration, otherwise TXDELAY and TXTAIL timings will be
        wrong.  You can omit SPEED and define RFBAUDS in the port
        instead.  Communication between between XRouter and YAM via
        the RS232 cable always takes place at 19200 bauds.

        PROTOCOL *must* be HDLC.  No other protocols are supported at
        present.

        Each YAM interface supports only one PORT.  You must use a
        separate INTERFACE and PORT for each YAM board.

        Port Settings
        ~~~~~~~~~~~~~
        A typical PORT might be defined as follows:

           PORT
              ID=YAM 1200 Bauds 144.650MHz
              INTERFACENUM=10
              CHANNEL=A
              SPEED=1200
              FULLDUP=0
              TXDELAY=150
           ENDPORT

        CHANNEL is ignored, but must be present.  FULLDUP can be used,
        as the YAM is capable of full duplex operation, but SOFTDCD is 
        ignored because it has no meaning for a YAM board.

        YAM will INTERLOCK with other YAM interfaces and with all
        types of SCC card, but not with KISS TNC's since XRouter has
        no knowledge of, or control over when a KISS TNC is
        transmitting.

        Notes
        ~~~~~
        The YAM modem uses TXD, RXD, RTS, CTS, DTR, DSR, RI and DCD so
        a full 8 wire plus ground cable is required.

        Some PC's either don't provide enough DC voltage/current to
        supply the YAM board or the RS232 inputs sink too much
        current.  This is a hardware problem, not an XRouter problem.
        It can be overcome by using an external supply to power the
        YAM board.

        XRouter does not program the FPGA therefore YAM modems must be 
        initialised by running YAMINIT (supplied with the modem)
        before starting XRouter.  It is probably best to do this in a
        startup batch file.  "YAMINIT yam12v11.mcs 1" will program the
        YAM for COM1 with 1200 baud RF speed.  The YAM is capable of
        1200, 2400 or 9600 baud simply by choosing the appropriate
        .MCS file.

        For further information you must refer to the YAM
        manufacturer's documentation.

CAVEATS
        YAM has not been tested since the XRouter code was ported from
        DOS to Windows.  Reports would be welcome.

SEE ALSO
        XROUTER.CFG(8) -- Main Configuration File.

YAM(9)                    END OF DOCUMENT
